/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.ide;

import com.zeroturnaround.serversetup.updater.model.Domain;
import java.io.File;
import java.util.Collections;
import org.zeroturnaround.common.Function1;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.jvm.JVMCache;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.common.server.jboss.JBossVariables;
import org.zeroturnaround.common.server.tomcat.CatalinaJavaHomeResolver;
import org.zeroturnaround.common.server.weblogic.WLSVariables;
import org.zeroturnaround.common.server.websphere.WASVariables;
import org.zeroturnaround.jrebel.client.common.EnvironmentUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHomeDetector {
    private static final JVMCache cache = JVMCache.getInstance(JavaHomeDetector.getTempDir());
    private static final Function1<String, JavaVM> StringToJavaHome = new Function1<String, JavaVM>(){

        @Override
        public JavaVM apply(String javaHome) {
            return cache.getJavaHomeJVM(javaHome);
        }
    };

    public void detectJavaHome(Domain domain) {
        domain.detectedJavaHome = this.getJavaHomeFor(domain);
    }

    public JavaVM getFallbackJVM() {
        return cache.getJavaExeJVM("java");
    }

    private Maybe<JavaVM> getJavaHomeFor(Domain domain) {
        switch (domain.containerInfo.getType()) {
            case TOMCAT: {
                return this.detectTomcatJavaHome(domain);
            }
            case WAS: {
                return this.detectWASJavaHome(domain);
            }
            case WEBLOGIC: {
                return this.detectWebLogicJavaHome(domain);
            }
            case JBOSS: {
                return this.detectJBossJavaHome(domain);
            }
        }
        return this.detectEnvJavaHome(domain);
    }

    private Maybe<JavaVM> detectEnvJavaHome(Domain domain) {
        return Maybe.nullable(System.getenv("JAVA_HOME")).map(StringToJavaHome);
    }

    private Maybe<JavaVM> detectTomcatJavaHome(Domain domain) {
        CatalinaJavaHomeResolver resolver = new CatalinaJavaHomeResolver(domain.containerInfo.getRoot(), JavaHomeDetector.getTempDir(), Collections.<String, String>emptyMap());
        return resolver.getJavaHome().map(StringToJavaHome);
    }

    private Maybe<JavaVM> detectJBossJavaHome(Domain domain) {
        String ext;
        String scriptName = "run";
        String string = ext = EnvironmentUtil.isWindows() ? ".bat" : ".sh";
        if (new File(domain.containerInfo.getRoot(), "bin/standalone" + ext).exists()) {
            scriptName = "standalone";
        }
        JBossVariables jboss = new JBossVariables(domain.containerInfo.getRoot(), scriptName, JavaHomeDetector.getTempDir(), Collections.<String, String>emptyMap());
        return jboss.getJavaHome().map(StringToJavaHome);
    }

    private Maybe<JavaVM> detectWASJavaHome(Domain domain) {
        WASVariables was = WASVariables.fromServerXmlPath(new File(domain.location, "server.xml"));
        Maybe<String> javaHomeOpt = was.getJavaHome();
        String javaHome = javaHomeOpt.getOrElse(new File(domain.containerInfo.getRoot(), "java").getAbsolutePath());
        return Maybe.some(cache.getJavaHomeJVM(javaHome));
    }

    private Maybe<JavaVM> detectWebLogicJavaHome(Domain domain) {
        WLSVariables wlsVars = new WLSVariables(Maybe.<File>none(), domain.location, JavaHomeDetector.getTempDir());
        return wlsVars.getJavaHome().map(new Function1<String, JavaVM>(){

            @Override
            public JavaVM apply(String javaHome) {
                return cache.getJavaHomeJVM(javaHome);
            }
        });
    }

    private static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }
}

