/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.dsl;

import com.zeroturnaround.serversetup.investigator.assertions.Assertion;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.ServerVersion;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerInfo {
    public static final String EXTRA_JAVAHOME = "java.home";
    private final ServerVersion version;
    private final ServerType type;
    private final File root;
    private final File[] domainFolders;
    private final Map<String, List<String>> extraProperties;

    public ContainerInfo(File root, ServerType type, ServerVersion version, File[] domainFolders) {
        this(root, type, version, domainFolders, null);
    }

    public ContainerInfo(File root, ServerType type, ServerVersion version, File[] domainFolders, Map<String, List<String>> extraProperties) {
        Assertion.notNulls(new Object[]{root, type, version});
        this.version = version;
        this.type = type;
        this.root = root;
        this.domainFolders = domainFolders == null ? null : (File[])domainFolders.clone();
        this.extraProperties = extraProperties != null ? Collections.unmodifiableMap(new HashMap<String, List<String>>(extraProperties)) : Collections.emptyMap();
    }

    public List<String> getExtraProperty(String propertyName) {
        List<String> result = this.extraProperties.get(propertyName);
        if (result != null) {
            return Collections.unmodifiableList(result);
        }
        return result;
    }

    public File getRoot() {
        return this.root;
    }

    public File[] getDomainFolders() {
        return this.domainFolders;
    }

    public ServerVersion getVersion() {
        return this.version;
    }

    public ServerType getType() {
        return this.type;
    }

    public String toString() {
        return this.type.displayName() + " " + this.version.toString();
    }
}

