/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.dsl;

import com.zeroturnaround.serversetup.investigator.assertions.Assertion;
import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerVersion;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.ConditionIsFalseException;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.ServerSetupDSLException;
import java.io.File;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class ServerRuleSet {
    private volatile ServerDSLContext context;
    protected ContainerInfo containerInfo;

    public final void init(ServerDSLContext context) {
        this.context = context;
    }

    public ServerDSLContext getContext() {
        return this.context;
    }

    private boolean stopForException(Throwable ex) {
        Throwable cause;
        Throwable throwable = cause = ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getCause() : ex;
        if (cause instanceof SecurityException) {
            throw (SecurityException)cause;
        }
        if (cause instanceof ServerSetupDSLException) {
            if (!(cause instanceof ConditionIsFalseException)) {
                throw (ServerSetupDSLException)cause;
            }
        } else if (!this.stopRulesForUnexpectedException(cause)) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check() {
        this.beforeCheck();
        boolean wholeResult = false;
        try {
            for (Method m : this.getClass().getMethods()) {
                if (this.context != null) {
                    this.context.reset();
                }
                if (!ServerRuleSet.isRuleVersion(m)) continue;
                try {
                    Boolean result = (Boolean)m.invoke((Object)this, new Object[0]);
                    if (result != null && !result.booleanValue()) continue;
                    wholeResult |= result == null ? true : result;
                    if (!this.firstSolvedRuleEnough()) continue;
                }
                catch (Throwable ex) {
                    if (!this.stopForException(ex)) continue;
                }
                break;
            }
            if (!wholeResult) {
                this.context.reset();
                try {
                    this.checkServerType(this.context);
                    wholeResult |= this.containerInfo != null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            boolean bl = wholeResult;
            return bl;
        }
        finally {
            this.afterCheck();
        }
    }

    public static ServerVersion extractVersionWithDottedPostfix(String stringVersion) {
        Assertion.notNull(stringVersion);
        String[] splitted = stringVersion.split("\\.");
        ArrayList<Integer> numericPart = new ArrayList<Integer>();
        String postfix = null;
        for (String s : splitted) {
            try {
                numericPart.add(Integer.parseInt(s.trim()));
            }
            catch (NumberFormatException ex) {
                postfix = s;
                break;
            }
        }
        int[] version = new int[numericPart.size()];
        int index = 0;
        for (Integer i : numericPart) {
            version[index++] = i;
        }
        return new ServerVersion(null, version, postfix);
    }

    private static boolean isRuleVersion(Method method) {
        if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            return method.getName().startsWith("rule") && (method.getReturnType() == Void.TYPE || method.getReturnType() == Boolean.TYPE) && method.getParameterTypes().length == 0;
        }
        return false;
    }

    protected boolean firstSolvedRuleEnough() {
        return true;
    }

    protected boolean stopRulesForUnexpectedException(Throwable unexpectedException) {
        if (unexpectedException instanceof ServerSetupDSLException) {
            throw (ServerSetupDSLException)unexpectedException;
        }
        throw new RuntimeException("Unexpected exception detected during rule set processing [" + this.getClass().getCanonicalName() + ']', unexpectedException);
    }

    protected void beforeCheck() {
        this.containerInfo = null;
    }

    protected void afterCheck() {
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public Document parseStringAsXMLDocument(String str) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(false);
            factory.setCoalescing(true);
            factory.setNamespaceAware(false);
            return factory.newDocumentBuilder().parse(new InputSource(new StringReader(str)));
        }
        catch (Exception ex) {
            throw new ConditionIsFalseException("Can't parse the string as xml", ex);
        }
    }

    public File checkFolderAndChangeIfNeed(File file) {
        return file;
    }

    public String removeQuotes(String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static boolean fileExists(ServerDSLContext context, String ... path) {
        context.reset();
        String fileName = path[path.length - 1];
        String[] folders = new String[path.length - 1];
        System.arraycopy(path, 0, folders, 0, path.length - 1);
        try {
            context.gotoFolder(folders).fileExists(fileName);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public void checkServerType(ServerDSLContext context) {
    }
}

