/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.dsl;

import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerVersion
implements Comparable<ServerVersion> {
    private static final Pattern PATTERN_VERSION_NUMBER = Pattern.compile("[[0-9]+\\.]+");
    private final String prefix;
    private final int[] version;
    private final String postfix;
    private final boolean unknown;

    public ServerVersion() {
        this.prefix = "UNKNOWN";
        this.version = new int[0];
        this.postfix = "";
        this.unknown = true;
    }

    public ServerVersion(String text) {
        if ("unknown".equalsIgnoreCase(text) || "".equals(text)) {
            this.prefix = "UNKNOWN";
            this.version = new int[0];
            this.postfix = "";
            this.unknown = true;
            return;
        }
        String[] splitted = text.split("\\-");
        switch (splitted.length) {
            case 0: {
                this.prefix = "";
                this.version = new int[0];
                this.postfix = "";
                break;
            }
            case 1: {
                if (PATTERN_VERSION_NUMBER.matcher(splitted[0].trim()).matches()) {
                    this.prefix = "";
                    this.version = ServerVersion.parseVersionNumber(splitted[0].trim());
                    this.postfix = "";
                    break;
                }
                this.prefix = splitted[0].trim();
                this.version = new int[0];
                this.postfix = "";
                break;
            }
            case 2: {
                if (PATTERN_VERSION_NUMBER.matcher(splitted[0].trim()).matches()) {
                    this.prefix = "";
                    this.version = ServerVersion.parseVersionNumber(splitted[0].trim());
                    this.postfix = splitted[1].trim();
                    break;
                }
                if (PATTERN_VERSION_NUMBER.matcher(splitted[1].trim()).matches()) {
                    this.prefix = splitted[0].trim();
                    this.version = ServerVersion.parseVersionNumber(splitted[1].trim());
                    this.postfix = "";
                    break;
                }
                this.prefix = splitted[0].trim();
                this.version = new int[0];
                this.postfix = splitted[1].trim();
                break;
            }
            case 3: {
                this.prefix = splitted[0].trim();
                this.version = ServerVersion.parseVersionNumber(splitted[1].trim());
                this.postfix = splitted[2].trim();
                break;
            }
            default: {
                throw new IllegalArgumentException("Must have only three parts - <prefix>-<n.u.m.b.e.r>-<postfix> [" + text + ']');
            }
        }
        this.unknown = false;
    }

    private static int[] parseVersionNumber(String str) {
        if (str == null || str.trim().length() == 0) {
            return new int[0];
        }
        String[] splitted = str.split("\\.");
        int[] result = new int[splitted.length];
        int index = 0;
        for (String s : splitted) {
            try {
                result[index++] = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("Can't decode version number [" + str + ']');
            }
        }
        return result;
    }

    public ServerVersion(String prefix, int[] version, String postfix) {
        this.prefix = prefix == null ? "" : prefix;
        this.version = version == null ? new int[]{} : (int[])version.clone();
        this.postfix = postfix == null ? "" : postfix;
        this.unknown = false;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public int[] getVersion() {
        return (int[])this.version.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(32);
        if (this.prefix != null && this.prefix.trim().length() > 0) {
            result.append(this.prefix);
        }
        if (this.version.length > 0) {
            if (result.length() > 0) {
                result.append('-');
            }
            result.append(this.versionAsString());
        }
        if (this.postfix != null && this.postfix.trim().length() > 0) {
            result.append('-').append(this.postfix);
        }
        return result.toString();
    }

    public String versionAsString() {
        if (this.version == null || this.version.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (int i : this.version) {
            if (!first) {
                result.append('.');
            } else {
                first = false;
            }
            result.append(i);
        }
        return result.toString();
    }

    @Override
    public int compareTo(ServerVersion that) {
        if (this.prefix.equals(that.prefix)) {
            int[] thatVersion = that.version;
            int result = 0;
            int maxNum = Math.max(this.version.length, thatVersion.length);
            for (int i = 0; i < maxNum; ++i) {
                int b;
                int a = i < this.version.length ? this.version[i] : 0;
                int n = b = i < thatVersion.length ? thatVersion[i] : 0;
                if (a > b) {
                    result = 1;
                    break;
                }
                if (a >= b) continue;
                result = -1;
                break;
            }
            if (result != 0) {
                return result;
            }
            return this.postfix.compareTo(that.postfix);
        }
        return this.prefix.compareTo(that.prefix);
    }

    public boolean versionEquals(int ... version) {
        if (version == null) {
            return false;
        }
        return this.compareTo(new ServerVersion(this.prefix, version, this.postfix)) == 0;
    }

    public boolean isVersionAtLeast(int ... version) {
        return this.versionEquals(version) || this.versionAfter(version);
    }

    public boolean versionBefore(int ... version) {
        if (version == null) {
            return false;
        }
        return this.compareTo(new ServerVersion(this.prefix, version, this.postfix)) < 0;
    }

    public boolean versionAfter(int ... version) {
        if (version == null) {
            return false;
        }
        return this.compareTo(new ServerVersion(this.prefix, version, this.postfix)) > 0;
    }
}

