/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.serverrules;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerRuleSet;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.ServerVersion;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.ConditionIsFalseException;
import java.io.File;
import java.io.FileFilter;

public class RulesGlassfishVersion
extends ServerRuleSet {
    public void rule_GlassfishVersion_ServerRoot() {
        String version = this.getContext().gotoFolder("glassfish", "modules").openArchiveEntry("glassfish.jar!META-INF/MANIFEST.MF").findManifestProperty("Bundle-Version").getStringPartAfterChar(':');
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.GLASSFISH, new ServerVersion(version), this.findAllDomainFolders());
    }

    private File[] findAllDomainFolders() {
        try {
            File domainFolder;
            String pathToDomain = this.getContext().reset().gotoFolder("glassfish", "config").openTextFile("asenv.conf").findProperty("AS_DEF_DOMAINS_PATH").getStringPartAfterChar('=');
            if (pathToDomain.startsWith("\"") && pathToDomain.endsWith("\"")) {
                pathToDomain = pathToDomain.substring(1, pathToDomain.length() - 1);
            }
            if ((domainFolder = new File(this.getContext().getCurrentFolder(), pathToDomain)).isDirectory()) {
                File[] domains = domainFolder.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                for (int i = 0; i < domains.length; ++i) {
                    domains[i] = this.checkFolderAndChangeIfNeed(domains[i]);
                }
                return domains;
            }
            return null;
        }
        catch (ConditionIsFalseException ex) {
            return null;
        }
    }

    public void checkServerType(ServerDSLContext context) {
        context.gotoFolder("glassfish", "modules").fileExists("glassfish.jar");
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.GLASSFISH, new ServerVersion(), new File[0]);
    }
}

