/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.serverrules;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerRuleSet;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.ServerVersion;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.ConditionIsFalseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RulesTomcatVersion
extends ServerRuleSet {
    public void rule_TomcatVersion() {
        this.assertNotTomee();
        String version = this.getContext().gotoFolder("lib").openArchiveEntry("catalina.jar!META-INF/MANIFEST.MF").findManifestProperty("Implementation-Version").getStringPartAfterChar(':');
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.TOMCAT, RulesTomcatVersion.extractVersionWithDottedPostfix(version), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNotTomee() {
        boolean tomee;
        try {
            this.getContext().gotoFolder("lib").openArchiveEntry("tomee-catalina-*.jar!META-INF/MANIFEST.MF");
            tomee = true;
        }
        catch (ConditionIsFalseException e) {
            tomee = false;
        }
        finally {
            this.getContext().reset();
        }
        if (tomee) {
            throw new ConditionIsFalseException("It's TomEE, not Tomcat");
        }
    }

    private void assertNotNewerVersion() {
        boolean newerVersion;
        try {
            this.getContext().gotoFolder("server", "lib").openArchiveEntry("catalina.jar!META-INF/MANIFEST.MF").findManifestProperty("Implementation-Version");
            newerVersion = true;
        }
        catch (ConditionIsFalseException ex) {
            newerVersion = false;
        }
        if (newerVersion) {
            throw new ConditionIsFalseException("It's newer version of Tomcat than processing by the rule");
        }
    }

    public boolean rule_TomcatVersion_OldVersion_basedOnReleaseNotesTxt() {
        this.assertNotTomee();
        this.assertNotNewerVersion();
        this.getContext().fileExists("tomcat-jk.jar");
        String releaseNotes = this.getContext().reset().openTextFile("RELEASE-NOTES*.txt").getOpenedTextFileAsString();
        ServerVersion version = RulesTomcatVersion.findMajorServerVersionAtReleaseNotes(releaseNotes);
        if (version != null) {
            this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.TOMCAT, version, null);
            return true;
        }
        return false;
    }

    public boolean rule_TomcatVersion_VeryOldVersion_basedOnTextAtReleaseNotes() {
        this.assertNotTomee();
        this.assertNotNewerVersion();
        String releaseNotes = this.getContext().reset().openTextFile("RELEASE-NOTES").getOpenedTextFileAsString();
        Pattern pattern = Pattern.compile("tomcat\\s+version\\s+((\\d+\\.{0,1})+){1}", 2);
        Matcher matcher = pattern.matcher(releaseNotes);
        if (matcher.find()) {
            String versionText = releaseNotes.substring(matcher.start(1), matcher.end(1));
            this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.TOMCAT, RulesTomcatVersion.extractVersionWithDottedPostfix(versionText), null);
            return true;
        }
        return false;
    }

    static ServerVersion findMajorServerVersionAtReleaseNotes(String releaseNotesText) {
        ServerVersion version = null;
        Pattern pattern = Pattern.compile("\\[(\\s*\\d+\\s*\\.{0,1}\\s*)+\\]");
        Matcher matcher = pattern.matcher(releaseNotesText);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String group = releaseNotesText.substring(start, end);
            ServerVersion foundVersion = RulesTomcatVersion.extractVersionWithDottedPostfix(group.substring(1, group.length() - 1));
            if (version == null) {
                version = foundVersion;
                continue;
            }
            version = foundVersion.versionAfter(version.getVersion()) ? foundVersion : version;
        }
        return version;
    }
}

