/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.serverrules;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerRuleSet;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.ServerVersion;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.ConditionIsFalseException;
import java.io.File;

public class RulesTomeeVersion
extends ServerRuleSet {
    public void rule_TomeeVersion() {
        String version = this.getContext().gotoFolder("lib").openArchiveEntry("tomee-catalina-*.jar!META-INF/MANIFEST.MF").findManifestProperty("Implementation-Version").getStringPartAfterChar(':');
        if (version.trim().equals("4.0.0")) {
            this.getContext().reset();
            try {
                String tomcatVersion = this.getContext().gotoFolder("lib").openArchiveEntry("catalina.jar!META-INF/MANIFEST.MF").findManifestProperty("Implementation-Version").getStringPartAfterChar(':');
                if (tomcatVersion.trim().equals("7.0.27")) {
                    version = "1.0.0";
                }
            }
            catch (ConditionIsFalseException conditionIsFalseException) {
                // empty catch block
            }
        }
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.TOMEE, RulesTomeeVersion.extractVersionWithDottedPostfix(version), null);
    }

    public void checkServerType(ServerDSLContext context) {
        if (RulesTomeeVersion.fileExists(context, "lib", "tomee-catalina-*.jar")) {
            this.containerInfo = new ContainerInfo(context.getRoot(), ServerType.TOMEE, new ServerVersion(), new File[0]);
        }
    }
}

