/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.model;

import com.zeroturnaround.serversetup.ide.JavaHomeDetector;
import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import java.io.File;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.jvm.JavaVM;

public class Domain {
    public final ContainerInfo containerInfo;
    public final File location;
    public Maybe<JavaVM> detectedJavaHome = Maybe.none();
    public Maybe<JavaVM> selectedJavaHome = Maybe.none();

    public Domain(ContainerInfo containerInfo, File domainRoot) {
        this.containerInfo = containerInfo;
        this.location = domainRoot;
    }

    public static Domain noDomain(ContainerInfo info) {
        return new Domain(info, null);
    }

    public static Domain of(ContainerInfo info, File domainRoot) {
        return new Domain(info, domainRoot);
    }

    public boolean isRealDomain() {
        return this.location != null;
    }

    public JavaVM getSelectedJavaOrFallback() {
        return this.selectedJavaHome.orElse(this.detectedJavaHome).getOrElse(new JavaHomeDetector().getFallbackJVM());
    }
}

