/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.model;

import com.zeroturnaround.serversetup.ide.JavaHomeDetector;
import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.updater.model.Domain;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domains {
    private static final JavaHomeDetector javaHomeDetector = new JavaHomeDetector();

    public static List<Domain> getDomains(ContainerInfo info) {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        if (info.getType().isDomainBased()) {
            File[] domainFolders = info.getDomainFolders();
            if (domainFolders != null) {
                for (File domainFolder : domainFolders) {
                    domains.add(Domains.newDomain(info, domainFolder));
                }
            }
        } else {
            domains.add(Domains.newDomain(info, null));
        }
        return domains;
    }

    private static Domain newDomain(ContainerInfo info, File folder) {
        Domain domain = new Domain(info, folder);
        javaHomeDetector.detectJavaHome(domain);
        return domain;
    }
}

