/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.modifiers;

import com.zeroturnaround.serversetup.investigator.assertions.Assertion;
import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.updater.model.Domain;
import com.zeroturnaround.serversetup.updater.model.Domains;
import com.zeroturnaround.serversetup.updater.modifiers.ChangedFile;
import com.zeroturnaround.serversetup.updater.modifiers.Macros;
import com.zeroturnaround.serversetup.updater.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.zeroturnaround.common.args.Arg;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.jrebel.client.JRebel;
import org.zeroturnaround.jrebel.client.cli.StandaloneJRebel;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModifier {
    protected static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    protected static final String MACROS_JREBEL_PATH = "jrebel_path";
    protected static final String MACROS_JREBEL_PATH_RAW = "jrebel_path_raw";
    protected static final String MACROS_ROOT = "root";
    protected static final String MACROS_ROOT_RAW = "root_raw";
    protected static final String MACROS_CURRENTFOLDER = "current_folder";
    protected static final String MACROS_CURRENTFOLDER_RAW = "current_folder_raw";
    protected static final String MACROS_ENVPROPS = "envprops";

    public List<ChangedFile> process(ServerDSLContext context, ContainerInfo containerInfo, File jrebelPath, Properties systemProperties) throws IOException {
        ArrayList<ChangedFile> allChanges = new ArrayList<ChangedFile>();
        StandaloneJRebel jrebel = new StandaloneJRebel(jrebelPath);
        for (Domain domain : Domains.getDomains(containerInfo)) {
            List<ChangedFile> changes = this.setJRebelEnabled(context, domain, jrebel, true, systemProperties, ProgressMonitor.NONE);
            allChanges.addAll(changes);
        }
        return allChanges;
    }

    public abstract boolean isVersionSupported(ContainerInfo var1);

    public abstract boolean isJRebelEnabled(Domain var1, JRebel var2) throws IOException;

    public abstract List<ChangedFile> setJRebelEnabled(ServerDSLContext var1, Domain var2, JRebel var3, boolean var4, Properties var5, ProgressMonitor var6) throws IOException;

    public ChangedFile makeChangedFileAtTheSameFolder(File sourceFile, String destinationFileName, String text, boolean executable) {
        File originalFile;
        Assertion.notNull(sourceFile);
        File baseFolder = sourceFile.isDirectory() ? sourceFile : sourceFile.getParentFile();
        File destinationFile = destinationFileName == null ? null : new File(baseFolder, destinationFileName);
        File file = originalFile = sourceFile.isDirectory() ? null : sourceFile;
        if (destinationFile != null && destinationFile.exists()) {
            originalFile = destinationFile;
        }
        return new ChangedFile(originalFile, destinationFile, text, executable);
    }

    public static String prepareStringForBatch(String str) {
        Assertion.notNull(str);
        String result = str;
        if (str.indexOf(32) >= 0) {
            result = '\"' + result + '\"';
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadtextResource(String textResource) throws IOException {
        Assertion.notNull(textResource);
        InputStream stream = this.getClass().getResourceAsStream(textResource);
        if (stream == null) {
            throw new FileNotFoundException("Can't find resource '" + textResource + '\'');
        }
        try {
            String string = IOUtils.toString(stream, "UTF8");
            return string;
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    public String replaceMacroses(String text, Set<Macros> macroses) {
        Assertion.notNulls(text, macroses);
        String str = text;
        for (Macros m : macroses) {
            str = str.replace("${{" + m.getName() + "}}", m.getValue());
        }
        return str;
    }

    public static List<String> split(String str) {
        String[] splitted;
        Assertion.notNull(str);
        ArrayList<String> result = new ArrayList<String>();
        for (String s : splitted = str.split("\n")) {
            result.add(s);
        }
        return result;
    }

    protected Set<Macros> prepareMacroses(File root, File currentFolder, File jrebelPath, Properties envProperties) {
        Assertion.notNulls(root, currentFolder, jrebelPath);
        HashSet<Macros> result = new HashSet<Macros>();
        result.add(new Macros(MACROS_ROOT, AbstractModifier.prepareStringForBatch(FilenameUtils.normalizeNoEndSeparator(root.getAbsolutePath()))));
        result.add(new Macros(MACROS_ROOT_RAW, FilenameUtils.normalizeNoEndSeparator(root.getAbsolutePath())));
        result.add(new Macros(MACROS_CURRENTFOLDER, AbstractModifier.prepareStringForBatch(FilenameUtils.normalizeNoEndSeparator(currentFolder.getAbsolutePath()))));
        result.add(new Macros(MACROS_CURRENTFOLDER_RAW, FilenameUtils.normalizeNoEndSeparator(currentFolder.getAbsolutePath())));
        result.add(new Macros(MACROS_JREBEL_PATH, AbstractModifier.prepareStringForBatch(FilenameUtils.normalizeNoEndSeparator(jrebelPath.getAbsolutePath()))));
        result.add(new Macros(MACROS_JREBEL_PATH_RAW, FilenameUtils.normalizeNoEndSeparator(jrebelPath.getAbsolutePath())));
        result.add(new Macros(MACROS_ENVPROPS, StringUtils.propertiesInJavaCLIFormat(envProperties)));
        return result;
    }

    public String convertXmlDocToString(Document doc) throws Exception {
        Assertion.notNull(doc);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }

    protected ArgChanges asArgChanges(Properties envProperties) {
        ArgChanges changes = new ArgChanges();
        for (Object keyObj : Collections.list(envProperties.propertyNames())) {
            String key = (String)keyObj;
            changes.add(Arg.property(key, envProperties.getProperty(key)));
        }
        return changes;
    }
}

