/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.modifiers;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.OperatingSystem;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.updater.model.Domain;
import com.zeroturnaround.serversetup.updater.modifiers.ChangedFile;
import com.zeroturnaround.serversetup.updater.modifiers.Macros;
import com.zeroturnaround.serversetup.updater.modifiers.ScriptBasedModifier;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatModifier
extends ScriptBasedModifier {
    @Override
    protected ChangedFile createScript(ServerDSLContext context, Domain domain, Set<Macros> macros, ProgressMonitor monitor) throws IOException {
        String resource = OperatingSystem.WINDOWS == context.getOS() ? "tomcat_windows.txt" : "tomcat_linux.txt";
        String text = this.replaceMacroses(this.loadtextResource(resource), macros);
        return ChangedFile.newOrModification(this.getScriptFile(domain, context.getOS()), text, true);
    }

    @Override
    protected File getScriptFile(Domain domain, OperatingSystem os) {
        String scriptBaseName = "startup-jrebel";
        String scriptExt = OperatingSystem.WINDOWS == os ? ".bat" : ".sh";
        return new File(domain.containerInfo.getRoot(), "bin/" + scriptBaseName + scriptExt);
    }

    @Override
    public boolean isVersionSupported(ContainerInfo info) {
        if (info.getType() == ServerType.TOMCAT) {
            return !info.getVersion().versionBefore(4) && info.getVersion().versionBefore(8);
        }
        return info.getType() == ServerType.TOMEE;
    }

    public String toString() {
        return "Tomcat WS Modifier v1.0";
    }
}

