/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.modifiers;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.OperatingSystem;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.updater.model.Domain;
import com.zeroturnaround.serversetup.updater.modifiers.ChangedFile;
import com.zeroturnaround.serversetup.updater.modifiers.Macros;
import com.zeroturnaround.serversetup.updater.modifiers.ScriptBasedModifier;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeblogicModifier
extends ScriptBasedModifier {
    @Override
    protected ChangedFile createScript(ServerDSLContext context, Domain domain, Set<Macros> macros, ProgressMonitor monitor) throws IOException {
        String resource = OperatingSystem.WINDOWS == context.getOS() ? "weblogic_windows.txt" : "weblogic_linux.txt";
        String text = this.replaceMacroses(this.loadtextResource(resource), macros);
        return ChangedFile.newOrModification(this.getScriptFile(domain, context.getOS()), text, true);
    }

    @Override
    protected File getScriptFile(Domain domain, OperatingSystem os) {
        String scriptBaseName = "startWebLogic-jrebel";
        String scriptExt = OperatingSystem.WINDOWS == os ? ".bat" : ".sh";
        return new File(domain.location, "bin/" + scriptBaseName + scriptExt);
    }

    @Override
    public boolean isVersionSupported(ContainerInfo info) {
        if (info.getType() == ServerType.WEBLOGIC) {
            return !info.getVersion().versionBefore(9);
        }
        return false;
    }

    public String toString() {
        return "Weblogic Modifier v1.0";
    }
}

