/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.modifiers;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.NotFoundException;
import com.zeroturnaround.serversetup.updater.exceptions.CantProcessDomainException;
import com.zeroturnaround.serversetup.updater.model.Domain;
import com.zeroturnaround.serversetup.updater.modifiers.AbstractModifier;
import com.zeroturnaround.serversetup.updater.modifiers.ChangedFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.store.WebSphereXmlArgStore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.jrebel.client.JRebel;
import org.zeroturnaround.jrebel.client.args.RebelArgs;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebsphereModifier
extends AbstractModifier {
    @Override
    public boolean isJRebelEnabled(Domain domain, JRebel jrebel) throws IOException {
        File serverXmlFile = this.getServerXmlFile(domain.location);
        return jrebel.isEnabledIn(new WebSphereXmlArgStore(serverXmlFile));
    }

    @Override
    public List<ChangedFile> setJRebelEnabled(ServerDSLContext context, Domain domain, JRebel jrebel, boolean enable, Properties envProperties, ProgressMonitor monitor) throws IOException {
        File serverXmlFile = this.getServerXmlFile(domain.location);
        JavaVM vm = domain.getSelectedJavaOrFallback();
        WebSphereXmlArgStore argStore = new WebSphereXmlArgStore(serverXmlFile);
        try {
            ArgChanges changes;
            ArgChanges argChanges = changes = enable ? jrebel.getInstallationArguments(vm, monitor) : jrebel.getUndoInstallationArguments();
            if (enable && vm.isIBM() && !domain.containerInfo.getVersion().versionBefore(6, 1)) {
                changes.add(RebelArgs.SHARECLASSES_NONE);
            } else {
                changes.remove(RebelArgs.SHARECLASSES_NONE);
            }
            if (enable) {
                changes.merge(this.asArgChanges(envProperties));
            }
            String newContent = argStore.preview(changes);
            return Collections.singletonList(new ChangedFile(serverXmlFile, serverXmlFile, newContent, false));
        }
        catch (Exception e) {
            throw new CantProcessDomainException("Error changing jvm arguments", domain.location, e);
        }
    }

    private File getServerXmlFile(File domainRoot) {
        File serverXmlFile = new File(domainRoot, "server.xml");
        if (!serverXmlFile.exists()) {
            throw new NotFoundException("Can't find file [" + serverXmlFile + ']');
        }
        return serverXmlFile;
    }

    @Override
    public boolean isVersionSupported(ContainerInfo info) {
        if (info == null) {
            return false;
        }
        return info.getType() == ServerType.WAS;
    }

    public String toString() {
        return "Websphere AS Modifier v1.0";
    }
}

