/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.utils;

import com.zeroturnaround.serversetup.investigator.assertions.Assertion;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private StringUtils() {
    }

    public static String shortStr(int maxLen, String str) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxLen) {
            int middleOfStr = str.length() / 2;
            int diff = str.length() - maxLen;
            int partslen = (str.length() - diff - 4) / 2;
            if (partslen <= 0) {
                return str;
            }
            return str.substring(0, partslen) + "...." + str.substring(str.length() - partslen);
        }
        return str;
    }

    public static int indexOfString(Pattern regularExpression, List<String> stringList) {
        return StringUtils.indexOfString(regularExpression, stringList, 0);
    }

    public static int indexOfString(Pattern regularExpression, List<String> stringList, int startIndex) {
        Assertion.notNulls(regularExpression, stringList);
        for (int i = startIndex; i < stringList.size(); ++i) {
            Matcher matcher = regularExpression.matcher(stringList.get(i));
            if (!matcher.matches()) continue;
            return i;
        }
        return -1;
    }

    public static String prepareStringForCLI(String str) {
        if (str.indexOf(32) >= 0) {
            return "\"" + str + "\"";
        }
        return str;
    }

    public static String propertiesInJavaCLIFormat(Properties props) {
        if (props == null || props.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(props.size() * 32);
        for (Object key : Collections.list(props.propertyNames())) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append("-D").append(key).append('=').append(props.getProperty((String)key));
        }
        return result.toString();
    }
}

