/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args;

import java.io.File;
import org.zeroturnaround.common.Pair;
import org.zeroturnaround.common.args.ArgOpaque;
import org.zeroturnaround.common.args.ArgTriple;
import org.zeroturnaround.common.args.ArgValueAgentWithPaths;
import org.zeroturnaround.common.args.ArgValuePath;
import org.zeroturnaround.common.args.ArgValuePaths;
import org.zeroturnaround.common.args.ArgValueString;
import org.zeroturnaround.common.options.Option;
import org.zeroturnaround.jrebel.client.config.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arg {
    public static ArgOpaque simple(String value) {
        return new ArgOpaque(value);
    }

    public static ArgTriple<String> triple(String key, String sep, String value) {
        return new ArgTriple<String>(key, sep, value);
    }

    public static ArgTriple<String> tripleWithPath(String key, String sep, File value) {
        return new ArgTriple<String>(key, sep, new ArgValuePath(value.getAbsolutePath()));
    }

    public static ArgTriple<Pair<String, String[]>> agentWithPaths(String key, String sep, File value, File ... values) {
        String[] paths = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            paths[i] = values[i].getAbsolutePath();
        }
        return new ArgTriple<Pair<String, String[]>>(key, sep, new ArgValueAgentWithPaths(value.getAbsolutePath(), paths));
    }

    public static ArgTriple<String[]> tripleWithPaths(String key, String sep, File ... value) {
        String[] paths = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            paths[i] = value[i].getAbsolutePath();
        }
        return new ArgTriple<String[]>(key, sep, new ArgValuePaths(paths));
    }

    public static ArgTriple<String> property(String key, String value) {
        return new ArgTriple<String>("-D" + key, "=", value);
    }

    public static ArgTriple<String> propertyWithPath(String key, File value) {
        return new ArgTriple<String>("-D" + key, "=", new ArgValuePath(value.getAbsolutePath()));
    }

    public static ArgTriple<String> property(Property property) {
        return Arg.property(property.getKey(), property.getValue());
    }

    public static ArgTriple<String> option(Option<?> option) {
        return new ArgTriple<String>("-D" + option.getName(), "=", new ArgValueString(option.getValueOrDefaultAsString()));
    }

    public static ArgTriple<String> optionWithPath(Option<File> option) {
        return new ArgTriple<String>("-D" + option.getName(), "=", new ArgValuePath(option.getValueOrDefaultAsString()));
    }
}

