/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args;

import java.io.File;
import org.zeroturnaround.common.Pair;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.ArgValue;
import org.zeroturnaround.common.args.parser.ArgsParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgValueAgentWithPaths
extends ArgValue<Pair<String, String[]>> {
    private static final String OPTIONS_SEPARATOR = "=";
    private static final String pathSeparator = File.pathSeparator;

    public ArgValueAgentWithPaths(String agentPath, String[] paths) {
        super(Pair.of(agentPath, paths));
    }

    @Override
    public String asString(ArgFormatter formatter) {
        StringBuilder buf = new StringBuilder();
        buf.append(formatter.formatPath((String)((Pair)this.value).a));
        if (((String[])((Pair)this.value).b).length > 0) {
            buf.append(OPTIONS_SEPARATOR);
            boolean first = true;
            for (String path : (String[])((Pair)this.value).b) {
                if (!first) {
                    buf.append(pathSeparator);
                } else {
                    first = false;
                }
                buf.append(formatter.formatPath(path));
            }
        }
        return buf.toString();
    }

    @Override
    public ArgValue<Pair<String, String[]>> fromString(String value) {
        String[] agentStr = value.split(OPTIONS_SEPARATOR, 2);
        String agentPath = ArgsParser.unquote(agentStr[0]);
        if (agentStr.length == 2) {
            String[] paths = agentStr[1].split(pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = ArgsParser.unquote(paths[i]);
            }
            return new ArgValueAgentWithPaths(agentPath, paths);
        }
        return new ArgValueAgentWithPaths(agentPath, new String[0]);
    }
}

