/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args;

import java.io.File;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.ArgValue;
import org.zeroturnaround.common.args.parser.ArgsParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgValuePaths
extends ArgValue<String[]> {
    private static final String pathSeparator = File.pathSeparator;

    public ArgValuePaths(String[] value) {
        super(value);
    }

    @Override
    public String asString(ArgFormatter formatter) {
        StringBuilder buf = new StringBuilder();
        for (String path : (String[])this.value) {
            if (buf.length() > 0) {
                buf.append(pathSeparator);
            }
            buf.append(formatter.formatPath(path));
        }
        return buf.toString();
    }

    @Override
    public ArgValue<String[]> fromString(String value) {
        String[] paths = value.split(pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = ArgsParser.unquote(paths[i]);
        }
        return new ArgValuePaths(paths);
    }
}

