/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.args.parser.ArgsParser;
import org.zeroturnaround.common.args.store.ITransientArgStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArgStore
implements ITransientArgStore<String> {
    private final String original;
    private final ArgsParser.ParsedArgs parsed;
    private final ArgFormatter formatter;

    public StringArgStore(String original) {
        this(original, ArgFormatter.QUOTED, false);
    }

    public StringArgStore(String original, ArgFormatter formatter, boolean propertySupport) {
        this.original = original;
        this.formatter = formatter;
        this.parsed = ArgsParser.parse(original, propertySupport);
    }

    @Override
    public String preview(ArgChanges changes) {
        StringBuilder result = new StringBuilder(this.original);
        this.applyRemovals(changes, result);
        this.applyAdditions(changes, result);
        return result.toString().trim();
    }

    private void applyRemovals(ArgChanges changes, StringBuilder result) {
        List<IArgument> allChanges = changes.all();
        ArrayList<ArgsParser.ArgWithWhitespace> orderedRemovals = new ArrayList<ArgsParser.ArgWithWhitespace>();
        block0: for (ArgsParser.ArgWithWhitespace exArg : this.parsed.args) {
            for (IArgument arg : allChanges) {
                if (!arg.matches(exArg.value)) continue;
                orderedRemovals.add(exArg);
                continue block0;
            }
        }
        Collections.sort(orderedRemovals, new Comparator<ArgsParser.ArgWithWhitespace>(){

            @Override
            public int compare(ArgsParser.ArgWithWhitespace o1, ArgsParser.ArgWithWhitespace o2) {
                return Integer.valueOf(o2.start).compareTo(o1.start);
            }
        });
        for (ArgsParser.ArgWithWhitespace removal : orderedRemovals) {
            result.delete(removal.start, removal.end);
        }
    }

    private void applyAdditions(ArgChanges changes, StringBuilder result) {
        for (IArgument arg : changes.additions) {
            String rendered = arg.asString(this.formatter);
            if (result.length() > 0) {
                result.insert(0, this.parsed.separator);
            }
            result.insert(0, rendered);
        }
    }

    @Override
    public boolean contains(IArgument target) {
        return this.findFirst(target).isDefined();
    }

    @Override
    public Maybe<IArgument> findFirst(IArgument target) {
        for (ArgsParser.ArgWithWhitespace exArg : this.parsed.args) {
            if (!target.matches(exArg.value)) continue;
            return Maybe.some(target.fromString(exArg.value));
        }
        return Maybe.none();
    }

    @Override
    public List<IArgument> findAll(IArgument target) {
        ArrayList<IArgument> foundArgs = new ArrayList<IArgument>();
        for (ArgsParser.ArgWithWhitespace exArg : this.parsed.args) {
            if (!target.matches(exArg.value)) continue;
            foundArgs.add(target.fromString(exArg.value));
        }
        return foundArgs;
    }

    public String original() {
        return this.original;
    }
}

