/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args.store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.store.CompositeArgStore;
import org.zeroturnaround.common.args.store.IPersistentArgStore;
import org.zeroturnaround.common.args.store.ITransientArgStore;
import org.zeroturnaround.common.args.store.StringListArgStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASLibertyTextFileArgStore
extends CompositeArgStore<List<String>>
implements IPersistentArgStore,
ITransientArgStore<String> {
    private static final ArgFormatter ARG_FORMATTER = ArgFormatter.SHORT_FILE_NAMES;
    private final File jvmOptionsFile;

    public WASLibertyTextFileArgStore(File jvmOptionsFile) {
        super(null);
        this.jvmOptionsFile = jvmOptionsFile;
        this.original = new StringListArgStore(WASLibertyTextFileArgStore.readOptions(jvmOptionsFile), ARG_FORMATTER);
    }

    @Override
    public void apply(ArgChanges changes) {
        List newArgs = (List)this.original.preview(changes);
        WASLibertyTextFileArgStore.writeOptions(this.jvmOptionsFile, newArgs);
    }

    @Override
    public String preview(ArgChanges changes) {
        List newArgs = (List)this.original.preview(changes);
        StringBuilder buf = new StringBuilder();
        String lineSep = "\n";
        try {
            lineSep = System.getProperty("line.separator");
        }
        catch (Exception e) {
            // empty catch block
        }
        for (String line : newArgs) {
            buf.append(line);
            buf.append(lineSep);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readOptions(File jvmOptionsFile) {
        BufferedReader reader = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            reader = new BufferedReader(new FileReader(jvmOptionsFile));
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (IOException e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOptions(File jvmOptionsFile, List<String> lines) {
        if (lines.isEmpty()) {
            if (!jvmOptionsFile.delete()) {
                // empty if block
            }
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(jvmOptionsFile));
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

