/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args.store;

import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.store.CompositeArgStore;
import org.zeroturnaround.common.args.store.IPersistentArgStore;
import org.zeroturnaround.common.args.store.ITransientArgStore;
import org.zeroturnaround.common.args.store.StringArgStore;
import org.zeroturnaround.common.xml.XmlUtil;
import org.zeroturnaround.common.xml.search.DomNamePredicate;
import org.zeroturnaround.common.xml.search.DomSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSphereXmlArgStore
extends CompositeArgStore<String>
implements IPersistentArgStore,
ITransientArgStore<String> {
    private static final ArgFormatter ARG_FORMATTER = ArgFormatter.SHORT_FILE_NAMES;
    private final File serverXmlFile;
    private final Document serverXml;
    private final Node jvmArgsAttribute;

    public WebSphereXmlArgStore(File serverXmlFile) {
        super(null);
        this.serverXmlFile = serverXmlFile;
        this.serverXml = XmlUtil.loadXmlFile(serverXmlFile);
        this.jvmArgsAttribute = WebSphereXmlArgStore.getGenericJvmArgumentsAttribute(this.serverXml);
        String originalArgsString = this.jvmArgsAttribute.getNodeValue();
        this.original = new StringArgStore(originalArgsString, ARG_FORMATTER, false);
    }

    @Override
    public void apply(ArgChanges changes) {
        String newArgsString = (String)this.original.preview(changes);
        if (!newArgsString.equals(((StringArgStore)this.original).original())) {
            this.jvmArgsAttribute.setNodeValue(newArgsString);
            XmlUtil.writeXmlFile(this.serverXml, this.serverXmlFile);
        }
    }

    @Override
    public String preview(ArgChanges changes) {
        String newArgsString = (String)this.original.preview(changes);
        this.jvmArgsAttribute.setNodeValue(newArgsString);
        return XmlUtil.writeXmlToString(this.serverXml);
    }

    private static Node getGenericJvmArgumentsAttribute(Node document) {
        List<Node> nodes = DomSearcher.findRecursively(document, new DomNamePredicate("jvmEntries"));
        if (nodes.size() != 1) {
            throw new RuntimeException("<jvmEntries> XML node not found or not unique!");
        }
        return nodes.get(0).getAttributes().getNamedItem("genericJvmArguments");
    }
}

