/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.exec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeExec {
    public static final Map<String, String> EMPTY_ENV = Collections.emptyMap();
    private final String charset;

    public SafeExec(String charset) {
        this.charset = charset;
    }

    public static ExecResult execute(String ... cmdArray) throws IOException {
        return SafeExec.execute(EMPTY_ENV, cmdArray);
    }

    public static ExecResult execute(Map<String, String> env, String ... cmdArray) throws IOException {
        return new SafeExec(null).exec(env, cmdArray);
    }

    public ExecResult exec(String ... cmdArray) throws IOException {
        return this.exec(EMPTY_ENV, cmdArray);
    }

    public ExecResult exec(Map<String, String> env, String ... cmdArray) throws IOException {
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        try {
            ProcessResult result = new ProcessExecutor().environment(env).command(cmdArray).readOutput(true).redirectError(error).execute();
            return this.mapResult(result, error);
        }
        catch (InvalidExitValueException e1) {
            return this.mapResult(e1.result(), error);
        }
        catch (InterruptedException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (TimeoutException e1) {
            throw new IOException(e1.getMessage());
        }
    }

    private ExecResult mapResult(ProcessResult result, ByteArrayOutputStream error) throws UnsupportedEncodingException {
        String stdOut = result.outputString(this.charset != null ? this.charset : Charset.defaultCharset().name());
        String errOut = this.charset != null ? error.toString(this.charset) : error.toString();
        int exitVal = result.exitValue();
        return new ExecResult(exitVal, stdOut, errOut);
    }

    public BinExecResult execBinOut(Map<String, String> env, String ... cmdArray) throws IOException {
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        try {
            ProcessResult result = new ProcessExecutor().environment(env).command(cmdArray).readOutput(true).redirectError(error).execute();
            return this.mapResultBinOut(result, error);
        }
        catch (InvalidExitValueException e1) {
            return this.mapResultBinOut(e1.result(), error);
        }
        catch (InterruptedException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (TimeoutException e1) {
            throw new IOException(e1.getMessage());
        }
    }

    private BinExecResult mapResultBinOut(ProcessResult result, ByteArrayOutputStream error) throws UnsupportedEncodingException {
        String errOut = this.charset != null ? error.toString(this.charset) : error.toString();
        int exitVal = result.exitValue();
        return new BinExecResult(exitVal, result.output(), errOut);
    }

    public static class BinExecResult {
        public final int exitCode;
        public final byte[] output;
        public final String errorOutput;

        public BinExecResult(int exitCode, byte[] output, String errorOutput) {
            this.exitCode = exitCode;
            this.output = output;
            this.errorOutput = errorOutput;
        }
    }

    public static class ExecResult {
        public final int exitCode;
        public final String output;
        public final String errorOutput;

        public ExecResult(int exitCode, String output, String errorOutput) {
            this.exitCode = exitCode;
            this.output = output;
            this.errorOutput = errorOutput;
        }

        public String lastLineOfOutput() {
            String trimmed = this.output.trim();
            int lastLine = trimmed.lastIndexOf("\n");
            return lastLine > -1 ? trimmed.substring(lastLine + 1).trim() : trimmed;
        }
    }
}

