/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.jvm;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.zeroturnaround.common.jvm.JavaExeJVM;
import org.zeroturnaround.common.jvm.JavaHomeJVM;
import org.zeroturnaround.common.jvm.JavaVM;

public class JVMCache {
    private static JVMCache instance;
    private final File tmpDir;
    private final Map<String, JavaVM> byPath = new HashMap<String, JavaVM>();

    public JVMCache(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public static synchronized JVMCache getInstance(File tmpDir) {
        if (instance == null) {
            instance = new JVMCache(tmpDir);
        }
        return instance;
    }

    public synchronized JavaVM getJavaExeJVM(String pathToJava) {
        JavaVM vm = this.byPath.get(pathToJava);
        if (vm == null) {
            vm = new JavaExeJVM(pathToJava, this.tmpDir);
            this.byPath.put(pathToJava, vm);
        } else if (!"java".equals(pathToJava)) {
            try {
                File newJava = new File(pathToJava).getCanonicalFile();
                if (vm.lastModified() < newJava.lastModified()) {
                    vm = new JavaExeJVM(pathToJava, this.tmpDir);
                    this.byPath.put(pathToJava, vm);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return vm;
    }

    public synchronized JavaVM getJavaHomeJVM(String javaHome) {
        JavaVM vm = this.byPath.get(javaHome);
        if (vm == null) {
            vm = new JavaHomeJVM(javaHome, this.tmpDir);
            this.byPath.put(javaHome, vm);
        } else {
            JavaHomeJVM newVM = new JavaHomeJVM(javaHome, this.tmpDir);
            if (vm.lastModified() < newVM.lastModified()) {
                vm = newVM;
                this.byPath.put(javaHome, vm);
            }
        }
        return vm;
    }
}

