/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.options;

import org.zeroturnaround.common.ListenerList;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComputedOption<A, B>
implements IOption<A>,
IValueChangedListener<B> {
    private IOption<B> underlying;
    private ListenerList<IValueChangedListener<A>> listeners = new ListenerList();

    public ComputedOption(IOption<B> underlying) {
        this.underlying = underlying;
        underlying.addValueChangedListener(this);
    }

    public abstract A apply(B var1);

    public abstract B unapply(A var1);

    @Override
    public A getDefaultValue() {
        return this.apply(this.underlying.getDefaultValue());
    }

    @Override
    public A getValue() {
        return this.apply(this.underlying.getValue());
    }

    @Override
    public A getValueOrDefault() {
        A value = this.getValue();
        return value != null ? value : this.getDefaultValue();
    }

    @Override
    public void setValue(A value) {
        this.underlying.setValue(this.unapply(value));
    }

    @Override
    public boolean isDefault() {
        return this.underlying.isDefault();
    }

    @Override
    public void addValueChangedListener(IValueChangedListener<A> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeValueChangedListener(IValueChangedListener<A> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void valueChanged(IOption<B> option) {
        for (IValueChangedListener<A> listener : this.listeners.getListeners()) {
            listener.valueChanged(this);
        }
    }
}

