/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.server.geronimo;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.exec.SafeExec;
import org.zeroturnaround.common.util.FileUtilsBackports;
import org.zeroturnaround.jrebel.client.common.EnvironmentUtil;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoVariables {
    private static final String JRE_HOME = "JRE_HOME";
    private final File serverHome;
    private final File tmpDir;
    private final Map<String, String> env;

    public GeronimoVariables(File serverHome, File tmpDir, Map<String, String> env) {
        this.serverHome = serverHome;
        this.tmpDir = tmpDir;
        this.env = env;
    }

    public Maybe<String> getJavaHome() {
        return this.resolveVariableFromEnv(JRE_HOME, this.env);
    }

    public Maybe<String> resolveVariableFromEnv(String name, Map<String, String> env) {
        try {
            boolean windows = EnvironmentUtil.isWindows();
            String ext = windows ? ".bat" : ".sh";
            File resolverScript = this.makeResolverScript(name, windows);
            String setEnv = new File(this.serverHome, "bin/setenv" + ext).getAbsolutePath();
            String setJavaEnv = new File(this.serverHome, "bin/setjavaenv" + ext).getAbsolutePath();
            SafeExec.ExecResult result = SafeExec.execute(env, resolverScript.getAbsolutePath(), setEnv, setJavaEnv);
            return Maybe.some(result.output.trim());
        }
        catch (IOException e) {
            JRebelClientAdapter.getInstance().error(e);
            return Maybe.none();
        }
    }

    private File makeResolverScript(String name, boolean windows) throws IOException {
        String ext = windows ? ".bat" : ".sh";
        String command = null;
        command = windows ? "@if exist \"%1\" call \"%1\"\n@call \"%2\"\n@echo %" + name + "%" : "if [ -r \"$1\" ]; then\n . \"$1\"\nfi\n. \"$2\"echo $" + name;
        File resolverScript = new File(this.tmpDir, "resolve_env_geronimo_" + name + ext);
        FileUtils.writeStringToFile(resolverScript, command);
        FileUtilsBackports.setExecutable(resolverScript, true);
        return resolverScript;
    }

    public static void main(String[] args) {
        GeronimoVariables vars = new GeronimoVariables(new File("C:/opt/containers/geronimo-tomcat6-javaee5-2.1.2"), new File("C:/tmp"), Collections.<String, String>emptyMap());
        Maybe<String> javaHome = vars.getJavaHome();
        if (javaHome.isDefined()) {
            System.out.println(javaHome.get());
        }
    }
}

