/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.server.weblogic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.common.Function0;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.exec.SafeExec;
import org.zeroturnaround.common.util.FileUtilsBackports;
import org.zeroturnaround.jrebel.client.common.EnvironmentUtil;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLSVariables {
    private final Maybe<File> serverDir;
    private final File domainDir;
    private final File tmpDir;

    public WLSVariables(Maybe<File> serverDir, File domainDir, File tmpDir) {
        this.serverDir = serverDir;
        this.domainDir = domainDir;
        this.tmpDir = tmpDir;
    }

    public Maybe<String> getJavaHome() {
        return this.resolveVariableFromDomainEnv("JAVA_HOME").orElse(new Function0<Maybe<String>>(){

            @Override
            public Maybe<String> apply() {
                return WLSVariables.this.resolveVariableFromProductProperties("WLS_JAVA_HOME");
            }
        });
    }

    public Maybe<String> getJavaHome(String vendor) {
        return this.resolveVariableFromDomainEnv("JAVA_HOME", Collections.singletonMap("JAVA_VENDOR", vendor)).orElse(new Function0<Maybe<String>>(){

            @Override
            public Maybe<String> apply() {
                return WLSVariables.this.resolveVariableFromProductProperties("WLS_JAVA_HOME");
            }
        });
    }

    public Maybe<String> resolveVariableFromProductProperties(String name) {
        if (!this.serverDir.isDefined()) {
            return Maybe.none();
        }
        Properties productProps = new Properties();
        try {
            productProps.load(new FileInputStream(new File(this.serverDir.get(), ".product.properties")));
            String value = productProps.getProperty(name);
            return value != null ? Maybe.some(value) : Maybe.none();
        }
        catch (Exception e) {
            JRebelClientAdapter.getInstance().error(e);
            return Maybe.none();
        }
    }

    public Maybe<String> resolveVariableFromDomainEnv(String name) {
        return this.resolveVariableFromDomainEnv(name, SafeExec.EMPTY_ENV);
    }

    public Maybe<String> resolveVariableFromDomainEnv(String name, Map<String, String> env) {
        try {
            boolean windows = EnvironmentUtil.isWindows();
            String ext = windows ? ".cmd" : ".sh";
            File resolverScript = this.makeResolverScript(name, windows);
            SafeExec.ExecResult result = SafeExec.execute(env, resolverScript.getAbsolutePath(), new File(this.domainDir, "bin/setDomainEnv" + ext).getAbsolutePath());
            return Maybe.some(result.output.trim());
        }
        catch (IOException e) {
            JRebelClientAdapter.getInstance().error(e);
            return Maybe.none();
        }
    }

    private File makeResolverScript(String name, boolean windows) throws IOException {
        String ext = windows ? ".cmd" : ".sh";
        String command = windows ? "@call %1\n@echo %" + name + "%" : "$1; echo $" + name;
        File resolverScript = new File(this.tmpDir, "resolve_from_domainEnv_" + name + ext);
        FileUtils.writeStringToFile(resolverScript, command);
        FileUtilsBackports.setExecutable(resolverScript, true);
        return resolverScript;
    }
}

