/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.server.websphere;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.zeroturnaround.common.Function0;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.xml.XmlUtil;
import org.zeroturnaround.common.xml.search.DomNamePredicate;
import org.zeroturnaround.common.xml.search.DomSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASVariables {
    protected static final Pattern REF = Pattern.compile("(\\$\\{(.*?)\\})");
    private final File serverDir;
    private final List<Document> docs;

    public WASVariables(File serverDir) {
        this.serverDir = serverDir;
        this.docs = new ArrayList<Document>();
        for (File varsFile : this.getVariablesFiles()) {
            if (!varsFile.exists()) continue;
            this.docs.add(XmlUtil.loadXmlFile(varsFile));
        }
    }

    public static WASVariables fromServerXmlPath(File serverXmlFile) {
        return new WASVariables(serverXmlFile.getParentFile());
    }

    public File[] getVariablesFiles() {
        return new File[]{new File(this.serverDir, "variables.xml"), new File(this.serverDir, "../../variables.xml"), new File(this.serverDir, "../../../../variables.xml")};
    }

    public Maybe<String> getJavaHome() {
        return this.resolveVariable("JAVA_HOME").orElse(new Function0<Maybe<String>>(){

            @Override
            public Maybe<String> apply() {
                try {
                    File appServerDir = WASVariables.this.serverDir;
                    for (int i = 0; i < 9; ++i) {
                        appServerDir = appServerDir.getParentFile();
                    }
                    return Maybe.some(new File(appServerDir, "java").getPath());
                }
                catch (Exception e) {
                    return Maybe.none();
                }
            }
        });
    }

    public Maybe<String> resolveVariable(String name) {
        Maybe<String> valueOpt = this.doResolve(name);
        if (valueOpt.isDefined()) {
            String value = valueOpt.get();
            Matcher m = REF.matcher(value);
            while (m.find()) {
                String refName = m.group(2);
                Maybe<String> refValue = this.resolveVariable(refName);
                if (refValue.isDefined()) {
                    value = m.replaceFirst(Matcher.quoteReplacement(refValue.get()));
                    m.reset(value);
                    continue;
                }
                return Maybe.none();
            }
            return Maybe.some(value);
        }
        return valueOpt;
    }

    private Maybe<String> doResolve(String name) {
        for (Document doc : this.docs) {
            List<Node> entries = DomSearcher.findRecursively(doc, new DomNamePredicate("entries"));
            for (Node node : entries) {
                String varName = node.getAttributes().getNamedItem("symbolicName").getTextContent();
                if (!name.equals(varName)) continue;
                return Maybe.some(node.getAttributes().getNamedItem("value").getTextContent());
            }
        }
        return Maybe.none();
    }
}

