/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel;

import java.util.ArrayList;
import java.util.List;
import org.zeroturnaround.javarebel.DiagnosticsInfo;
import org.zeroturnaround.javarebel.DiagnosticsInfoManager;
import org.zeroturnaround.javarebel.DiagnosticsInfoManagerFactory;
import org.zeroturnaround.javarebel.DiagnosticsInfoProvider;
import org.zeroturnaround.javarebel.SQLQueryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLDiagnosticsInfoProvider
implements DiagnosticsInfoProvider {
    public static final String ID = "SqlQueries";
    static DiagnosticsInfoManager manager = DiagnosticsInfoManagerFactory.getInstance();
    static final SQLDiagnosticsInfoProvider provider = new SQLDiagnosticsInfoProvider();
    private final List<SQLQueryInfo> queries = new ArrayList<SQLQueryInfo>();

    @Override
    public String getId() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiagnosticsInfo getDiagnosticsInfo(String[] params) {
        String requestId = params[1];
        DiagnosticsInfo answer = new DiagnosticsInfo(ID);
        for (SQLQueryInfo q : this.queries) {
            if (!requestId.equals(q.requestId)) continue;
            SQLQueryInfo sQLQueryInfo = q;
            synchronized (sQLQueryInfo) {
                DiagnosticsInfo query = new DiagnosticsInfo("query");
                query.addChild(new DiagnosticsInfo("id", q.getId()));
                query.addChild(new DiagnosticsInfo("timestamp", q.timestamp));
                query.addChild(new DiagnosticsInfo("requestId", q.requestId));
                query.addChild(new DiagnosticsInfo("rawSql", q.rawSql));
                query.addChild(new DiagnosticsInfo("sql", q.sql));
                query.addChild(new DiagnosticsInfo("duration", q.duration));
                query.addChild(new DiagnosticsInfo("stackTrace", this.getStackTrace(q.stackTrace)));
                query.addChild(new DiagnosticsInfo("statementId", q.statementId));
                query.addChild(new DiagnosticsInfo("processingTime", q.processingTime));
                query.addChild(new DiagnosticsInfo("numRowsProcessed", q.numRowsProcessed));
                answer.addChild(query);
            }
        }
        return answer;
    }

    private List<DiagnosticsInfo> getStackTrace(StackTraceElement[] stack) {
        ArrayList<DiagnosticsInfo> result = new ArrayList<DiagnosticsInfo>();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement e = stack[i];
            DiagnosticsInfo ex = new DiagnosticsInfo("stack");
            ex.addChild(new DiagnosticsInfo("class", e.getClassName()));
            ex.addChild(new DiagnosticsInfo("method", e.getMethodName()));
            ex.addChild(new DiagnosticsInfo("line", Integer.toString(e.getLineNumber())));
            ex.addChild(new DiagnosticsInfo("file", e.getFileName()));
            result.add(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLQueryInfo registerSqlQuery(Object statement, String rawSql, String sql, long timestamp, long duration) {
        SQLDiagnosticsInfoProvider sQLDiagnosticsInfoProvider = provider;
        synchronized (sQLDiagnosticsInfoProvider) {
            String requestId = SQLDiagnosticsInfoProvider.getId(manager.getRequestId());
            SQLQueryInfo info = new SQLQueryInfo(requestId, statement, rawSql, sql, timestamp, duration, Thread.currentThread().getStackTrace());
            SQLDiagnosticsInfoProvider.provider.queries.add(info);
            if (SQLDiagnosticsInfoProvider.provider.queries.size() > 200) {
                SQLDiagnosticsInfoProvider.provider.queries.remove(0);
            }
            return info;
        }
    }

    private static String getId(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    static {
        manager.addDiagnosticsInfoProvider(provider);
    }
}

