/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel;

public class SQLQueryInfo {
    final long timestamp;
    final long duration;
    final String requestId;
    final String rawSql;
    final String sql;
    final String statementId;
    final StackTraceElement[] stackTrace;
    volatile long processingTime;
    volatile int numRowsProcessed;

    public SQLQueryInfo(String requestId, Object statement, String rawSql, String sql, long timestamp, long duration, StackTraceElement[] stackTrace) {
        this.timestamp = timestamp;
        this.duration = duration;
        this.requestId = requestId;
        this.rawSql = rawSql != null ? rawSql.trim() : null;
        this.sql = sql != null ? sql.trim() : null;
        this.stackTrace = this.removeTopJrebelElements(stackTrace);
        this.statementId = this.getId(statement);
        this.processingTime = -1L;
        this.numRowsProcessed = -1;
    }

    public synchronized void addProcessingInfo(long time, int numRowsProcessed) {
        this.processingTime = time;
        this.numRowsProcessed = numRowsProcessed;
    }

    private StackTraceElement[] removeTopJrebelElements(StackTraceElement[] trace) {
        StackTraceElement[] answer = new StackTraceElement[trace.length - 5];
        System.arraycopy(trace, 5, answer, 0, trace.length - 5);
        return answer;
    }

    public String getId() {
        return this.getId(this);
    }

    private String getId(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }
}

