/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.common.Version;
import org.zeroturnaround.jrebel.client.util.JarUtil;

public class JRebelJar {
    private final File file;
    private File copiedFile = null;

    public JRebelJar(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Expected jrebel.jar, but argument was null");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Expected jrebel.jar, but argument was not a file: " + file);
        }
        if (!"jrebel".equals(JarUtil.getJarSpecificationTitle(file))) {
            throw new IllegalArgumentException("The specified file is not a valid jrebel.jar");
        }
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCopiedFile() {
        File file = this.file;
        synchronized (file) {
            return this.copiedFile != null ? this.copiedFile : this.file;
        }
    }

    protected File copyTo(File destDir) {
        File file = this.file;
        synchronized (file) {
            if (this.copiedFile != null) {
                return this.copiedFile;
            }
            try {
                File destFile = new File(destDir, "jrebel.jar");
                if (destFile.exists()) {
                    destFile.delete();
                } else if (!destDir.exists()) {
                    destDir.mkdirs();
                }
                FileUtils.copyFile(this.file, destFile);
                this.copiedFile = destFile;
                return this.copiedFile;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getJRebelImplementation() {
        return JarUtil.getJRebelImplementation(this.file);
    }

    public String getImplementationTitle() {
        return JarUtil.getJarImplementationTitle(this.file);
    }

    public String getImplementationVersionString() {
        return JarUtil.getJarImplementationVersionString(this.file);
    }

    public Version getVersion() {
        return JarUtil.getJarSpecificationVersion(this.file);
    }

    public String getVersionString() {
        return JarUtil.getJarSpecificationVersionString(this.file);
    }

    public String getFullVersionString() {
        return JarUtil.getJarSpecificationVersionString(this.file) + " (" + JarUtil.getJarImplementationVersionString(this.file) + ")";
    }
}

