/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.args;

import java.io.File;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.jrebel.client.JRebel;
import org.zeroturnaround.jrebel.client.JRebelNativeAgent;
import org.zeroturnaround.jrebel.client.args.RebelArgs;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

public class RebelArgsBuilder {
    public final ArgChanges changes = new ArgChanges();
    private final JRebel rebel;

    public RebelArgsBuilder(JRebel rebel) {
        this.rebel = rebel;
    }

    public RebelArgsBuilder javaagent() {
        this.changes.add(RebelArgs.agent(this.rebel.getJarFile()));
        return this;
    }

    public RebelArgsBuilder nativeAgent(boolean vm64bit) {
        JRebelNativeAgent nativeAgent = this.rebel.getNativeAgent();
        Maybe<File> agentLib = nativeAgent.agentLibForCurrentOS(vm64bit);
        if (!agentLib.isDefined()) {
            throw new IllegalStateException("Trying to use native agent without native library present.");
        }
        this.changes.add(RebelArgs.nativeAgent(agentLib.get()));
        return this;
    }

    public RebelArgsBuilder bootClasspathWithAgentJar(File bootstrapJarPath) {
        this.changes.add(RebelArgs.bootClasspath(bootstrapJarPath, this.rebel.getJarFile()));
        return this;
    }

    public RebelArgsBuilder bootClasspathWithoutAgentJar(File bootstrapJarPath) {
        this.changes.add(RebelArgs.bootClasspath(bootstrapJarPath));
        return this;
    }

    public RebelArgsBuilder optNoverify() {
        if (this.rebel.needsNoVerifyWithJavaagent()) {
            this.noverify();
        }
        return this;
    }

    public RebelArgsBuilder noverify() {
        this.changes.add(RebelArgs.NOVERIFY);
        return this;
    }

    public RebelArgsBuilder shareClassesNone() {
        this.changes.add(RebelArgs.SHARECLASSES_NONE);
        return this;
    }

    public RebelArgsBuilder rebelWorkspacePath(File path) {
        this.changes.add(RebelArgs.rebelWorkspacePath(path));
        return this;
    }

    public RebelArgsBuilder rebelMetadataPath(File path) {
        this.changes.add(RebelArgs.rebelMetadataPath(path));
        return this;
    }

    public RebelArgsBuilder forceConfig(JRebelConfiguration config) {
        this.changes.add(RebelArgs.configFile(config));
        this.changes.add(RebelArgs.logFile(config));
        return this;
    }

    public RebelArgsBuilder notificationUrl(String url) {
        this.changes.add(RebelArgs.notificationUrl(url));
        return this;
    }

    public RebelArgsBuilder proxySettings(JRebelConfiguration config) {
        if (config.passProxySettings().getValueOrDefault().booleanValue()) {
            ArgChanges proxyArgs = RebelArgsBuilder.getProxyArgs();
            this.changes.merge(proxyArgs);
        }
        return this;
    }

    public static ArgChanges getProxyArgs() {
        ArgChanges changes = new ArgChanges();
        try {
            String nonProxyHosts;
            String proxyHost = System.getProperty("http.proxyHost");
            String proxyPort = System.getProperty("http.proxyPort");
            if (proxyHost != null && proxyPort != null) {
                changes.add(RebelArgs.httpProxyHost(proxyHost));
                changes.add(RebelArgs.httpProxyPort(proxyPort));
            }
            if ((nonProxyHosts = System.getProperty("http.nonProxyHosts")) != null) {
                changes.add(RebelArgs.httpNonProxyHosts(nonProxyHosts));
            }
        }
        catch (Exception e) {
            JRebelClientAdapter.getInstance().error(e);
        }
        return changes;
    }
}

