/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.zeroturnaround.jrebel.client.JRebel;
import org.zeroturnaround.jrebel.client.bootstrap.BootstrapKey;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapCache {
    private static final String BOOTSTRAP_MAP_FILE = "bootstrap-cache.map";
    private final JRebel jrebel;
    private final Map<BootstrapKey, String> bootstrapMap;

    public BootstrapCache(JRebel jrebel) {
        this.jrebel = jrebel;
        this.bootstrapMap = BootstrapCache.load(jrebel);
    }

    public boolean containsKey(BootstrapKey key) {
        return this.bootstrapMap.containsKey(key);
    }

    public String get(BootstrapKey key) {
        return this.bootstrapMap.get(key);
    }

    public void put(BootstrapKey key, String pathToBootstrap) {
        this.bootstrapMap.put(key, pathToBootstrap);
        BootstrapCache.save(this.jrebel, this.bootstrapMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<BootstrapKey, String> load(JRebel jrebel) {
        File bootstrapDir = jrebel.getBootstrapCacheDir();
        File bootstrapMapFile = new File(bootstrapDir, BOOTSTRAP_MAP_FILE);
        HashMap<BootstrapKey, String> bootstrapMap = new HashMap<BootstrapKey, String>();
        if (bootstrapMapFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(bootstrapMapFile)));
                String line = reader.readLine();
                while (line != null) {
                    String[] split = line.split("=");
                    String jrebelVersion = split[0];
                    String pathToJava = split[1];
                    String bootstrapPath = split[2];
                    BootstrapKey bootstrapKey = new BootstrapKey(jrebelVersion, pathToJava);
                    bootstrapMap.put(bootstrapKey, bootstrapPath);
                    line = reader.readLine();
                }
                IOUtils.closeQuietly(reader);
            }
            catch (Exception e) {
                JRebelClientAdapter.getInstance().error(e);
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }
        return bootstrapMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(JRebel jrebel, Map<BootstrapKey, String> bootstrapMap) {
        File bootstrapDir = jrebel.getBootstrapCacheDir();
        File bootstrapMapFile = new File(bootstrapDir, BOOTSTRAP_MAP_FILE);
        PrintWriter writer = null;
        try {
            if (!bootstrapDir.exists()) {
                bootstrapDir.mkdirs();
            }
            writer = new PrintWriter(bootstrapMapFile);
            for (Map.Entry<BootstrapKey, String> entry : bootstrapMap.entrySet()) {
                writer.println(entry.getKey() + "=" + entry.getValue());
            }
        }
        catch (Exception e) {
            JRebelClientAdapter.getInstance().error(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e2) {}
            }
        }
    }
}

