/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.cli;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.zeroturnaround.common.jvm.JVMUtil;
import org.zeroturnaround.common.jvm.JavaExeJVM;
import org.zeroturnaround.jrebel.client.cli.SilentOutJRebelClientAdapter;
import org.zeroturnaround.jrebel.client.cli.StandaloneJRebel;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;
import org.zeroturnaround.zip.ZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRebelBootstrapVerifier {
    public static void main(String[] args) throws Exception {
        SilentOutJRebelClientAdapter.init();
        File jarFile = new File(args[0]);
        StandaloneJRebel jrebel = new StandaloneJRebel(jarFile);
        File bootstrapJarFile = new File(args[1]);
        File javaExe = new File(args[2]);
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        JavaExeJVM vm = new JavaExeJVM(javaExe.getAbsolutePath(), tmpDir);
        Map<String, String> javaProps = vm.getVersionProperties();
        byte[] bytes = ZipUtil.unpackEntry(bootstrapJarFile, "jrebel-bootstrap.properties");
        Properties bootstrapProps = new Properties();
        bootstrapProps.load(new ByteArrayInputStream(bytes));
        if (JRebelBootstrapVerifier.compare(javaProps, bootstrapProps)) {
            System.exit(0);
        } else {
            File newBootstrap = jrebel.getBootstrapJarFile(vm, ProgressMonitor.NONE);
            System.out.println(newBootstrap.getAbsolutePath());
            System.exit(2);
        }
    }

    public static boolean compare(Map<String, String> javaProps, Properties bootstrapProps) {
        String vmName = javaProps.get("java.vm.name");
        String vmVersion = javaProps.get("java.vm.version");
        String vmInfo = javaProps.get("java.vm.info");
        String vmVendor = javaProps.get("java.vm.vendor");
        String osArch = javaProps.get("os.arch");
        String javaVer = JVMUtil.getDetailedJavaVersion(vmName, vmVersion, vmInfo, vmVendor, osArch);
        String vmName2 = bootstrapProps.getProperty("java.vm.name");
        String vmVersion2 = bootstrapProps.getProperty("java.vm.version");
        String vmInfo2 = bootstrapProps.getProperty("java.vm.info");
        String vmVendor2 = bootstrapProps.getProperty("java.vm.vendor");
        String osArch2 = bootstrapProps.getProperty("os.arch");
        String bootstrapVer = JVMUtil.getDetailedJavaVersion(vmName2, vmVersion2, vmInfo2, vmVendor2, osArch2);
        return javaVer.equals(bootstrapVer);
    }
}

