/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.config;

import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;
import org.zeroturnaround.jrebel.client.config.CustomPropertyBoolean;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomPropertyOption<T>
implements IOption<T> {
    private final JRebelConfiguration config;
    protected final String key;
    private final T defaultValue;

    public CustomPropertyOption(JRebelConfiguration config, String key, T defaultValue) {
        this.config = config;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static IOption<Boolean> boolWithDefault(JRebelConfiguration config, String key, boolean defaultValue) {
        return new CustomPropertyBoolean(config, key, defaultValue);
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isDefault() {
        Object value = this.getValue();
        return value == null && this.defaultValue == null || value != null && value.equals(this.defaultValue);
    }

    protected String getStringValue() {
        return this.config.getCustomProperty(this.key);
    }

    @Override
    public void addValueChangedListener(IValueChangedListener<T> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeValueChangedListener(IValueChangedListener<T> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T getValueOrDefault() {
        Object value = this.getValue();
        return value != null ? value : this.defaultValue;
    }
}

