/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.licensing;

import java.io.File;
import java.util.Calendar;
import org.zeroturnaround.common.Either;
import org.zeroturnaround.javarebel.Licensing;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JRebelLicensing {
    protected static final String MSG_LICENSE_EXPIRED = "Your JRebel license has expired!";
    protected static final String MSG_NO_VALID_LICENSE = "You do not have a valid license!";
    protected String ideId;
    protected final JRebelConfiguration config;

    public JRebelLicensing(JRebelConfiguration config, String ideId) {
        this.config = config;
        this.ideId = ideId;
    }

    public abstract void goOffline() throws Licensing.ActivationException;

    public abstract void goOffline(int var1) throws Licensing.ActivationException;

    public abstract void goOnline() throws Licensing.ActivationException;

    public abstract Either<String, Licensing.SDKLicenseInfo> activateLicenseToken(String var1);

    public abstract Either<String, Licensing.SDKLicenseInfo> validateLicenseToken(String var1);

    public abstract Either<String, Licensing.SDKLicenseInfo> activateLicenseFile(File var1);

    public abstract Either<String, Licensing.SDKLicenseInfo> validateLicenseFile(File var1);

    public abstract LicensingStatus getLicensingStatus();

    public String extractMessage(Licensing.ActivationException e) {
        if (e.getFaultString() != null) {
            return e.getFaultString();
        }
        switch (e.getFaultCode()) {
            case 1: {
                return "Error saving temproary file";
            }
            case 2: {
                return "Error saving license file";
            }
            case 3: {
                return "Invalid license";
            }
            case 4: {
                return "Error saving properties file";
            }
            case 5: {
                return "Error connecting to license server";
            }
            case 6: {
                return "License server not configured?";
            }
            case 7: {
                return "Invalid license code";
            }
            case 8: {
                return "Unable to connect to myJRebel";
            }
            case 9: {
                return "The license has expired";
            }
            case 11: {
                return "The provided License file does not exist or is unreadable";
            }
            case 10: {
                return "The myJRebel license has been activated too many times, please contact support";
            }
        }
        if (e.getLicenseInfo() != null && e.getLicenseInfo().getLicenseType() == 5 && e.getLicenseInfo().getValidUntil().before(Calendar.getInstance())) {
            return "You have already used up your 14-day JRebel trial period. To extend the period, please contact sales@zeroturnaround.com";
        }
        return "Error(" + e.getFaultCode() + ") occured: " + e.getFaultString();
    }

    protected <T> Either<String, Licensing.SDKLicenseInfo> doActivationAction(ActivationAction<T> action, T licenseInput) {
        try {
            Licensing.SDKLicenseInfo license = action.activate(licenseInput);
            if (license.isValid()) {
                this.fireActivationEvent();
                return Either.right(license);
            }
            return Either.left("Not a valid license");
        }
        catch (Licensing.ActivationException e) {
            return Either.left(this.extractMessage(e));
        }
    }

    protected void fireActivationEvent() {
    }

    protected <T> Either<String, Licensing.SDKLicenseInfo> doValidationAction(ActivationAction<T> action, T licenseInput) {
        try {
            Licensing.SDKLicenseInfo license = action.activate(licenseInput);
            if (license.isValid()) {
                return Either.right(license);
            }
            return Either.left("Not a valid license");
        }
        catch (Licensing.ActivationException e) {
            return Either.left(this.extractMessage(e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ActivationAction<T> {
        public Licensing.SDKLicenseInfo activate(T var1) throws Licensing.ActivationException;
    }
}

