/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.licensing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.zeroturnaround.common.Either;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.store.StringListArgStore;
import org.zeroturnaround.common.exec.SafeExec;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.javarebel.Licensing;
import org.zeroturnaround.jrebel.client.JRebel;
import org.zeroturnaround.jrebel.client.JRebelCoreInterface;
import org.zeroturnaround.jrebel.client.args.RebelArgsBuilder;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensing;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRebelLicensingCLI
extends JRebelLicensing {
    private final JRebel jrebel;
    private final JavaVM jvm;

    public JRebelLicensingCLI(JRebelConfiguration config, JRebel jrebel, JavaVM jvm, String ideId) {
        super(config, ideId);
        this.jrebel = jrebel;
        this.jvm = jvm;
    }

    @Override
    public void goOffline() throws Licensing.ActivationException {
        this.makeLicensingCall("goOffline", null);
    }

    @Override
    public void goOffline(int days) throws Licensing.ActivationException {
        this.makeLicensingCall("goOffline", String.valueOf(days));
    }

    @Override
    public void goOnline() throws Licensing.ActivationException {
        this.makeLicensingCall("goOnline", null);
    }

    @Override
    public Either<String, Licensing.SDKLicenseInfo> activateLicenseToken(String licenseToken) {
        licenseToken = licenseToken.replaceAll("(\\r|\\n)", "");
        return this.doActivationAction(new JRebelLicensing.ActivationAction<String>(){

            @Override
            public Licensing.SDKLicenseInfo activate(String license) throws Licensing.ActivationException {
                return JRebelLicensingCLI.this.makeLicensingCall("activateFromKey", license);
            }
        }, licenseToken);
    }

    @Override
    public Either<String, Licensing.SDKLicenseInfo> validateLicenseToken(String licenseToken) {
        licenseToken = licenseToken.replaceAll("(\\r|\\n)", "");
        return this.doValidationAction(new JRebelLicensing.ActivationAction<String>(){

            @Override
            public Licensing.SDKLicenseInfo activate(String license) throws Licensing.ActivationException {
                return JRebelLicensingCLI.this.makeLicensingCall("validateFromKey", license);
            }
        }, licenseToken);
    }

    @Override
    public Either<String, Licensing.SDKLicenseInfo> activateLicenseFile(File licenseFile) {
        return this.doActivationAction(new JRebelLicensing.ActivationAction<File>(){

            @Override
            public Licensing.SDKLicenseInfo activate(File license) throws Licensing.ActivationException {
                return JRebelLicensingCLI.this.makeLicensingCall("activateFromFile", license.getAbsolutePath());
            }
        }, licenseFile);
    }

    @Override
    public Either<String, Licensing.SDKLicenseInfo> validateLicenseFile(File licenseFile) {
        return this.doValidationAction(new JRebelLicensing.ActivationAction<File>(){

            @Override
            public Licensing.SDKLicenseInfo activate(File license) throws Licensing.ActivationException {
                return JRebelLicensingCLI.this.makeLicensingCall("validateFromFile", license.getAbsolutePath());
            }
        }, licenseFile);
    }

    @Override
    public LicensingStatus getLicensingStatus() {
        try {
            Licensing.SDKLicenseInfo license = this.makeLicensingCall("getCurrentLicense", null);
            if (license.isValid()) {
                return new LicensingStatus(license, null);
            }
            return new LicensingStatus(license, "You do not have a valid license!");
        }
        catch (Licensing.ExpiredLicenseException e) {
            return new LicensingStatus(e.getLicenseInfo(), "Your JRebel license has expired!");
        }
        catch (Licensing.ActivationException e) {
            throw new RuntimeException("Invalid exception from licensing API", e);
        }
    }

    private Licensing.SDKLicenseInfo makeLicensingCall(String cmd, String arg) throws Licensing.ActivationException {
        JRebelCoreInterface core = this.jrebel.getCoreInterface(this.jvm.pathToJavaExe());
        try {
            String[] vmArgs = new String[]{"-Drebel.log.stdout=false", "-Drebel.env.ide=" + this.ideId, "-Drebel.properties=" + this.config.getConfigurationFile().getAbsolutePath(), "-Drebel.license_server.legacy=" + System.getProperty("rebel.license_server.legacy", "false")};
            ArgChanges proxyArgs = RebelArgsBuilder.getProxyArgs();
            if (proxyArgs.hasAdditions()) {
                Object withProxyArgs = new StringListArgStore(new ArrayList<String>(Arrays.asList(vmArgs)), ArgFormatter.ID).preview(proxyArgs);
                vmArgs = withProxyArgs.toArray(new String[withProxyArgs.size()]);
            }
            SafeExec.BinExecResult result = core.executeLicensingCommand(vmArgs, cmd, arg != null ? arg : "");
            switch (result.exitCode) {
                case 0: {
                    if (result.output.length == 0) {
                        throw new RuntimeException("Empty result from licensing API call: " + cmd);
                    }
                    try {
                        Object obj = new ObjectInputStream(new ByteArrayInputStream(result.output)).readObject();
                        return (Licensing.SDKLicenseInfo)obj;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Invalid result from licensing API call: " + cmd, e);
                    }
                }
                case 1: {
                    throw new RuntimeException(result.errorOutput);
                }
                case 2: {
                    if (result.output.length == 0) {
                        throw new RuntimeException("Empty result from licensing API call: " + cmd);
                    }
                    try {
                        Object obj = new ObjectInputStream(new ByteArrayInputStream(result.output)).readObject();
                        if (obj instanceof Licensing.ActivationException) {
                            throw (Licensing.ActivationException)obj;
                        }
                        if (obj instanceof Licensing.ExpiredLicenseException) {
                            throw (Licensing.ExpiredLicenseException)obj;
                        }
                        if (obj instanceof Throwable) {
                            throw new RuntimeException("Invalid Exception from licensing API call: " + cmd, (Throwable)obj);
                        }
                        throw new RuntimeException("Expected exception from licensing API call: " + cmd + ", but got " + obj.getClass().getName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Invalid result from licensing API call: " + cmd, e);
                    }
                }
            }
            throw new RuntimeException("Invalid error code (" + result.exitCode + ") from licensing API call: " + cmd);
        }
        catch (IOException e) {
            throw new RuntimeException("Error communicating with licensing API", e);
        }
    }

    @Override
    protected synchronized void fireActivationEvent() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    JRebelLicensingCLI.this.makeLicensingCall("sendActivationMessage", null);
                }
                catch (Licensing.ActivationException activationException) {
                    // empty catch block
                }
            }
        }, "Activation");
        thread.setDaemon(true);
        thread.start();
    }
}

