/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.licensing;

import java.io.File;
import java.net.MalformedURLException;
import org.zeroturnaround.common.Either;
import org.zeroturnaround.javarebel.Licensing;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensing;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensingClassLoader;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRebelLicensingSameProcess
extends JRebelLicensing {
    private final Licensing licensing;
    private final File jrebelJar;

    public JRebelLicensingSameProcess(JRebelConfiguration config, File jrebelJar, ClassLoader parent, String ideId) {
        super(config, ideId);
        this.jrebelJar = jrebelJar;
        this.licensing = this.loadLicensingImpl(this.createLicensingCL(parent));
    }

    private ClassLoader createLicensingCL(ClassLoader parent) {
        try {
            return new JRebelLicensingClassLoader(this.jrebelJar.toURI().toURL(), parent);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Licensing loadLicensingImpl(ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass("com.zeroturnaround.javarebel.SDKLicensingImpl");
            return (Licensing)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void goOffline() throws Licensing.ActivationException {
        this.goOffline(1);
    }

    @Override
    public void goOffline(int days) throws Licensing.ActivationException {
        this.licensing.goOffline(days);
    }

    @Override
    public void goOnline() throws Licensing.ActivationException {
        this.licensing.goOnline();
    }

    @Override
    public Either<String, Licensing.SDKLicenseInfo> activateLicenseToken(String licenseToken) {
        licenseToken = licenseToken.replaceAll("(\\r|\\n)", "");
        return this.doActivationAction(new JRebelLicensing.ActivationAction<String>(){

            @Override
            public Licensing.SDKLicenseInfo activate(String license) throws Licensing.ActivationException {
                return JRebelLicensingSameProcess.this.licensing.activateFromKey(license);
            }
        }, licenseToken);
    }

    @Override
    public Either<String, Licensing.SDKLicenseInfo> validateLicenseToken(String licenseToken) {
        licenseToken = licenseToken.replaceAll("(\\r|\\n)", "");
        return this.doActivationAction(new JRebelLicensing.ActivationAction<String>(){

            @Override
            public Licensing.SDKLicenseInfo activate(String license) throws Licensing.ActivationException {
                return JRebelLicensingSameProcess.this.licensing.validateFromKey(license);
            }
        }, licenseToken);
    }

    @Override
    public Either<String, Licensing.SDKLicenseInfo> activateLicenseFile(File licenseFile) {
        return this.doActivationAction(new JRebelLicensing.ActivationAction<File>(){

            @Override
            public Licensing.SDKLicenseInfo activate(File license) throws Licensing.ActivationException {
                return JRebelLicensingSameProcess.this.licensing.activateFromFile(license);
            }
        }, licenseFile);
    }

    @Override
    public Either<String, Licensing.SDKLicenseInfo> validateLicenseFile(File licenseFile) {
        return this.doActivationAction(new JRebelLicensing.ActivationAction<File>(){

            @Override
            public Licensing.SDKLicenseInfo activate(File license) throws Licensing.ActivationException {
                return JRebelLicensingSameProcess.this.licensing.validateFromFile(license);
            }
        }, licenseFile);
    }

    @Override
    public LicensingStatus getLicensingStatus() {
        try {
            Licensing.SDKLicenseInfo license = this.licensing.getCurrentLicense();
            if (license.isValid()) {
                return new LicensingStatus(license, null);
            }
            return new LicensingStatus(license, "You do not have a valid license!");
        }
        catch (Licensing.ExpiredLicenseException e) {
            return new LicensingStatus(e.getLicenseInfo(), "Your JRebel license has expired!");
        }
    }
}

