/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.licensing;

import java.util.Calendar;
import org.zeroturnaround.common.Either;
import org.zeroturnaround.javarebel.Licensing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicensingStatus {
    private static final long MS_PER_DAY = 86400000L;
    public final Licensing.SDKLicenseInfo license;
    public final String error;

    public LicensingStatus(Licensing.SDKLicenseInfo license, String error) {
        this.license = license;
        this.error = error;
    }

    public Either<String, Licensing.SDKLicenseInfo> toEither() {
        if (this.isValid()) {
            return Either.right(this.license);
        }
        return Either.left(this.hasError() ? this.error : "You do not have a valid license!");
    }

    public boolean hasLicense() {
        return this.license != null;
    }

    public boolean hasServerLicense() {
        return this.hasLicense() && (2 == this.license.getLicenseType() || 3 == this.license.getLicenseType() || 1 == this.license.getLicenseType());
    }

    public boolean hasValidLicenseType() {
        return this.hasLicense() && this.license.getLicenseType() != 0;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean isValid() {
        return !this.hasError() && this.hasLicense() && this.license.isValid();
    }

    public Integer evaluationExpiryDays() {
        int licenseType = this.license.getLicenseType();
        if (5 == licenseType && this.license.getValidUntil() != null) {
            long current = Calendar.getInstance().getTimeInMillis();
            long validUntil = this.license.getValidUntil().getTimeInMillis();
            long ms = validUntil - current;
            long days = ms / 86400000L;
            return (int)(days + 1L);
        }
        return null;
    }
}

