/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.stats;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.stats.Redeploy;
import org.zeroturnaround.jrebel.client.stats.TimeAmount;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsFile {
    private LinkedList<Redeploy> redeploys = new LinkedList();
    private File file;

    public StatsFile(File file) throws IOException {
        this.file = file;
        this.refresh();
    }

    public int getAvgRedeployTime() {
        return JRebelConfiguration.getDefault().avgRedeployTime().getValueOrDefault();
    }

    public void refresh() throws IOException {
        String line;
        this.redeploys.clear();
        BufferedReader in = new BufferedReader(new FileReader(this.file));
        TimeAmount avgRedeployTime = TimeAmount.seconds(this.getAvgRedeployTime());
        while ((line = in.readLine()) != null) {
            try {
                if (line.contains("heartbeat")) continue;
                String[] tokens = line.trim().split("\\s+");
                if (tokens.length == 2) {
                    this.redeploys.add(new Redeploy(Long.parseLong(tokens[0]), TimeAmount.seconds(Integer.parseInt(tokens[1]))));
                    continue;
                }
                if (tokens.length != 1) continue;
                this.redeploys.add(new Redeploy(Long.parseLong(tokens[0]), avgRedeployTime));
            }
            catch (Exception e) {}
        }
        in.close();
        Collections.sort(this.redeploys);
    }

    public int getTotalNumberOfRedeploys() {
        return this.redeploys.size();
    }

    public TimeAmount getTotalSavedTime() {
        return TimeAmount.seconds(this.savedTimeSeconds(this.redeploys));
    }

    public int getRedeploysInLast(TimeAmount period) {
        long millis = period.getUnit().toMillis(period.getAmount());
        long now = System.currentTimeMillis();
        return this.getRedeploysFrom(now - millis).size();
    }

    public TimeAmount getSavedTimeInLast(TimeAmount period) {
        long millis = period.getUnit().toMillis(period.getAmount());
        long now = System.currentTimeMillis();
        return TimeAmount.seconds(this.savedTimeSeconds(this.getRedeploysFrom(now - millis)));
    }

    public long getNumberOfDaysRecorded() {
        try {
            long millis = this.redeploys.getFirst().getTime();
            long now = System.currentTimeMillis();
            return (now - millis) / 86400000L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private int savedTimeSeconds(Collection<Redeploy> collection) {
        int savedTime = 0;
        for (Redeploy redeploy : collection) {
            savedTime = (int)((long)savedTime + redeploy.getDuration().getUnit().toSeconds(redeploy.getDuration().getAmount()));
        }
        return savedTime;
    }

    private Collection<Redeploy> getRedeploysPeriod(long startMilliseconds, long endMilliseconds) {
        LinkedList<Redeploy> result = new LinkedList<Redeploy>();
        for (Redeploy redeploy : this.redeploys) {
            if (redeploy.getTime() < startMilliseconds || redeploy.getTime() > endMilliseconds) continue;
            result.add(redeploy);
        }
        return result;
    }

    public Collection<Redeploy> getRedeploysFrom(long startMilliseconds) {
        return this.getRedeploysPeriod(startMilliseconds, Long.MAX_VALUE);
    }

    public Collection<Redeploy> getRedeploysTo(long endMilliseconds) {
        return this.getRedeploysPeriod(Long.MIN_VALUE, endMilliseconds);
    }

    public Collection<Redeploy> getRedeploys() {
        return new LinkedList<Redeploy>(this.redeploys);
    }
}

