/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client.util;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.zeroturnaround.common.Version;

public class JarUtil {
    private static final Attributes.Name JREBEL_IMPLEMENTATION = new Attributes.Name("JRebel-Implementation");

    public static String getJarSpecificationTitle(File file) {
        return JarUtil.getJarManifestEntry(file, Attributes.Name.SPECIFICATION_TITLE);
    }

    public static String getJarImplementationTitle(File file) {
        return JarUtil.getJarManifestEntry(file, Attributes.Name.IMPLEMENTATION_TITLE);
    }

    public static String getJRebelImplementation(File file) {
        return JarUtil.getJarManifestEntry(file, JREBEL_IMPLEMENTATION);
    }

    public static Version getJarSpecificationVersion(File file) {
        String specVer = JarUtil.getJarSpecificationVersionString(file);
        if (specVer == null || "".equals(specVer.trim())) {
            return Version.EMPTY;
        }
        return new Version(specVer);
    }

    public static String getJarSpecificationVersionString(File file) {
        return JarUtil.getJarManifestEntry(file, Attributes.Name.SPECIFICATION_VERSION);
    }

    public static String getJarImplementationVersionString(File file) {
        return JarUtil.getJarManifestEntry(file, Attributes.Name.IMPLEMENTATION_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJarManifestEntry(File file, Attributes.Name field) {
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Attributes manifest = jar.getManifest().getMainAttributes();
            String string = manifest.getValue(field);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

