################################################################################
# Copyright (c) 2014 URBS. All Rights Reserved.                                #
#                                                                              #
# By using this software, you agree to respect Terms and Conditions of Modelur #
# PRE-BETA Partner Program (please see http://www.modelur.com/legal/terms or   #
# ../Modelur/license/MPR-PROGRAM.txt for more information).                    #
################################################################################
require 'sketchup'
require 'extensions'
module Modelur
	MODELUR_VERSION_INTERNAL = 400
	mac = (RUBY_PLATFORM =~ /darwin/i) ? true : false
	if mac == true
		MODELUR_PLATFORM = 'mac_os_x'
	else
		MODELUR_PLATFORM = 'windows'
	end
	MODELUR_RUBY_VERSION = RUBY_VERSION.to_i
	modelurExtension = SketchupExtension.new "Modelur", File.join('Modelur','lib','int','ruby', 'modelur_extensionLoader')
	modelurExtension.creator = 'The Modelur Team'
	modelurExtension.copyright = '2009-2014, URBS'
	modelurExtension.version = '0.4.0 (Pre-beta 4), valid until May 31th 2015.'
	modelurDescription = 'Modelur is 3D application for parametric urban design. For more information, please visit www.modelur.com.'
	modelurExtension.description = modelurDescription
	Sketchup.register_extension modelurExtension, true
end
