################################################################################
# Copyright (c) 2014 URBS. All Rights Reserved.                                #
#                                                                              #
# By using this software, you agree to respect Terms and Conditions of Modelur #
# PRE-BETA Partner Program (please see http://www.modelur.com/legal/terms or   #
# ../Modelur/license/MPR-PROGRAM.txt for more information).                    #
################################################################################
module Modelur
	rubyLocation = File.expand_path(File.dirname(__FILE__))
	modelur_path = (rubyLocation.split 'Modelur')
	i = 0
	combined_path = String.new
	while i < modelur_path.length-1
		if i == 0
			combined_path = File.join(modelur_path[i],'Modelur')
		else
			combined_path = File.join(combined_path, modelur_path[i],'Modelur')
		end
		i += 1
	end
	unless File.exists? combined_path
		path = Sketchup.find_support_file('Plugins') 
		MODELUR_INSTALL_PATH = File.join(path, 'Modelur')
	else
		MODELUR_INSTALL_PATH = combined_path
	end	
end

def Modelur::load_Modelur()
	rubyScriptsPath  = File.join(Modelur::MODELUR_INSTALL_PATH,'lib', 'int', 'ruby')
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_upgrading'))
	Modelur::UpgradeController.perform_upgrade
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_util'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_classesExtensions'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_observers'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_userInterface'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_headsUpDisplay'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_geometry'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_tools'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_dependencies'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_landUses'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_model'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_building'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_parametricMaps'))
	Sketchup.load(File.join(rubyScriptsPath, 'modelur_controller'))
	Modelur.modelur_loaded = true
	Modelur::Controller.initialize
end

Sketchup.load File.join(Modelur::MODELUR_INSTALL_PATH,'lib','int','ruby','modelur_json')
Sketchup.load File.join(Modelur::MODELUR_INSTALL_PATH,'lib','ext','ruby','fileutils')
Sketchup.load File.join(Modelur::MODELUR_INSTALL_PATH,'lib','int','ruby','modelur_validation')