/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.ArrayList;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.Configuration;
import javax.cache.ExpiryPolicy;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerRegistration;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableConfiguration<K, V>
implements Configuration<K, V> {
    protected ArrayList<CacheEntryListenerRegistration<? super K, ? super V>> cacheEntryListenerRegistrations = new ArrayList();
    protected CacheLoader<K, ? extends V> cacheLoader;
    protected CacheWriter<? super K, ? super V> cacheWriter;
    protected ExpiryPolicy<? super K, ? super V> expiryPolicy;
    protected boolean isReadThrough;
    protected boolean isWriteThrough;
    protected boolean isStatisticsEnabled;
    protected boolean isStoreByValue;
    protected boolean isTransactionsEnabled;
    protected IsolationLevel txnIsolationLevel;
    protected Mode txnMode;

    public MutableConfiguration() {
        this.expiryPolicy = new ExpiryPolicy.Default<K, V>();
        this.isStoreByValue = true;
        this.txnIsolationLevel = IsolationLevel.NONE;
        this.txnMode = Mode.NONE;
    }

    public MutableConfiguration(Iterable<CacheEntryListenerRegistration<? super K, ? super V>> regs, CacheLoader<K, ? extends V> cacheLoader, CacheWriter<? super K, ? super V> cacheWriter, ExpiryPolicy<? super K, ? super V> expiryPolicy, boolean isReadThrough, boolean isWriteThrough, boolean isStatisticsEnabled, boolean isStoreByValue, boolean isTransactionsEnabled, IsolationLevel txnIsolationLevel, Mode txnMode) {
        for (CacheEntryListenerRegistration<K, V> reg : regs) {
            this.registerCacheEntryListener(reg.getCacheEntryListener(), reg.isOldValueRequired(), reg.getCacheEntryFilter(), reg.isSynchronous());
        }
        this.cacheLoader = cacheLoader;
        this.cacheWriter = cacheWriter;
        this.expiryPolicy = expiryPolicy;
        this.isReadThrough = isReadThrough;
        this.isWriteThrough = isWriteThrough;
        this.isStatisticsEnabled = isStatisticsEnabled;
        this.isStoreByValue = isStoreByValue;
        this.isTransactionsEnabled = isTransactionsEnabled;
        this.txnIsolationLevel = txnIsolationLevel;
        this.txnMode = txnMode;
    }

    public MutableConfiguration(Configuration<K, V> cfg) {
        this(cfg.getCacheEntryListenerRegistrations(), cfg.getCacheLoader(), cfg.getCacheWriter(), cfg.getExpiryPolicy(), cfg.isReadThrough(), cfg.isWriteThrough(), cfg.isStatisticsEnabled(), cfg.isStoreByValue(), cfg.isTransactionsEnabled(), cfg.getTransactionIsolationLevel(), cfg.getTransactionMode());
    }

    @Override
    public boolean isReadThrough() {
        return this.isReadThrough;
    }

    public MutableConfiguration<K, V> setReadThrough(boolean isReadThrough) {
        this.isReadThrough = isReadThrough;
        return this;
    }

    @Override
    public boolean isWriteThrough() {
        return this.isWriteThrough;
    }

    public MutableConfiguration<K, V> setWriteThrough(boolean isWriteThrough) {
        this.isWriteThrough = isWriteThrough;
        return this;
    }

    @Override
    public boolean isStoreByValue() {
        return this.isStoreByValue;
    }

    public MutableConfiguration<K, V> setStoreByValue(boolean isStoreByValue) {
        this.isStoreByValue = isStoreByValue;
        return this;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public MutableConfiguration<K, V> setStatisticsEnabled(boolean isEnabled) {
        this.isStatisticsEnabled = isEnabled;
        return this;
    }

    @Override
    public boolean isTransactionsEnabled() {
        return this.isTransactionsEnabled;
    }

    public MutableConfiguration<K, V> setTransactionsEnabled(boolean isEnabled) {
        this.isTransactionsEnabled = isEnabled;
        return this;
    }

    @Override
    public IsolationLevel getTransactionIsolationLevel() {
        return this.txnIsolationLevel;
    }

    public MutableConfiguration<K, V> setTransactions(IsolationLevel level, Mode mode) {
        this.txnIsolationLevel = level;
        this.txnMode = mode;
        return this;
    }

    @Override
    public Mode getTransactionMode() {
        return this.txnMode;
    }

    @Override
    public Iterable<CacheEntryListenerRegistration<? super K, ? super V>> getCacheEntryListenerRegistrations() {
        return this.cacheEntryListenerRegistrations;
    }

    public MutableConfiguration<K, V> registerCacheEntryListener(CacheEntryListener<? super K, ? super V> listener, boolean requireOldValue, CacheEntryEventFilter<? super K, ? super V> filter, boolean synchronous) {
        SimpleCacheEntryListenerRegistration<? super K, ? super V> reg = new SimpleCacheEntryListenerRegistration<K, V>(listener, filter, requireOldValue, synchronous);
        this.cacheEntryListenerRegistrations.add(reg);
        return this;
    }

    @Override
    public CacheLoader<K, ? extends V> getCacheLoader() {
        return this.cacheLoader;
    }

    public MutableConfiguration<K, V> setCacheLoader(CacheLoader<K, ? extends V> loader) {
        this.cacheLoader = loader;
        return this;
    }

    @Override
    public CacheWriter<? super K, ? super V> getCacheWriter() {
        return this.cacheWriter;
    }

    public MutableConfiguration<K, V> setCacheWriter(CacheWriter<? super K, ? super V> writer) {
        this.cacheWriter = writer;
        return this;
    }

    @Override
    public ExpiryPolicy<? super K, ? super V> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public MutableConfiguration<K, V> setExpiryPolicy(ExpiryPolicy<? super K, ? super V> policy) {
        this.expiryPolicy = policy;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleCacheEntryListenerRegistration<K, V>
    implements CacheEntryListenerRegistration<K, V> {
        private final CacheEntryListener<? super K, ? super V> _listener;
        private final CacheEntryEventFilter<? super K, ? super V> _filter;
        private final boolean _isOldValueRequired;
        private final boolean _isSynchronous;

        SimpleCacheEntryListenerRegistration(CacheEntryListener<? super K, ? super V> listener, CacheEntryEventFilter<? super K, ? super V> filter, boolean isOldValueRequired, boolean isSynchronous) {
            if (listener == null) {
                throw new NullPointerException();
            }
            this._listener = listener;
            this._filter = filter;
            this._isOldValueRequired = isOldValueRequired;
            this._isSynchronous = isSynchronous;
        }

        @Override
        public CacheEntryListener<? super K, ? super V> getCacheEntryListener() {
            return this._listener;
        }

        @Override
        public boolean isOldValueRequired() {
            return this._isOldValueRequired;
        }

        @Override
        public CacheEntryEventFilter<? super K, ? super V> getCacheEntryFilter() {
            return this._filter;
        }

        @Override
        public boolean isSynchronous() {
            return this._isSynchronous;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._listener + "]";
        }
    }
}

