/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.IndexedValueExpression;
import javax.servlet.jsp.jstl.core.IteratedExpression;
import javax.servlet.jsp.jstl.core.IteratedValueExpression;
import javax.servlet.jsp.jstl.core.LoopTag;
import javax.servlet.jsp.jstl.core.LoopTagStatus;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public abstract class LoopTagSupport
extends TagSupport
implements IterationTag,
TryCatchFinally,
LoopTag {
    protected int begin;
    protected boolean beginSpecified;
    protected ValueExpression deferredExpression;
    protected int end = -1;
    protected boolean endSpecified;
    protected int step = 1;
    protected boolean stepSpecified;
    protected String itemId;
    protected String statusId;
    private Object _initialVar;
    private Object _current;
    private LoopTagStatus _status;
    private Object _oldStatus;
    private int _index;
    private int _count;
    private ValueExpression _mapped;

    public void setVar(String id) {
        this.itemId = id;
    }

    public void setVarStatus(String id) {
        this.statusId = id;
    }

    protected void validateBegin() throws JspTagException {
        if (this.begin < 0) {
            throw new JspTagException("Invalid loop tag, 'begin' < 0.");
        }
    }

    protected void validateEnd() throws JspTagException {
        if (this.end < 0) {
            throw new JspTagException("Invalid loop tag, 'end' < 0.");
        }
    }

    protected void validateStep() throws JspTagException {
        if (this.step <= 0) {
            throw new JspTagException("Invalid loop tag, 'step' <= 0.");
        }
    }

    protected abstract void prepare() throws JspTagException;

    protected abstract Object next() throws JspTagException;

    protected abstract boolean hasNext() throws JspTagException;

    public Object getCurrent() {
        return this._current;
    }

    public LoopTagStatus getLoopStatus() {
        return this._status;
    }

    private ValueExpression createIndexedExpression(int index) throws JspTagException {
        Object items = this.deferredExpression.getValue(this.pageContext.getELContext());
        if (items == null) {
            return this.deferredExpression;
        }
        if (items instanceof Collection) {
            return new IndexedValueExpression(this.deferredExpression, index);
        }
        if (items.getClass().isArray()) {
            return new IndexedValueExpression(this.deferredExpression, index);
        }
        if (items instanceof Map) {
            return new IteratedValueExpression(new IteratedExpression(this.deferredExpression, null), index);
        }
        if (items instanceof Iterator) {
            return new IteratedValueExpression(new IteratedExpression(this.deferredExpression, null), index);
        }
        if (items instanceof Enumeration) {
            return new IteratedValueExpression(new IteratedExpression(this.deferredExpression, null), index);
        }
        if (items instanceof String) {
            return new IteratedValueExpression(new IteratedExpression(this.deferredExpression, this.getDelims()), index);
        }
        throw new JspTagException("unknown items value '" + items + "'");
    }

    public int doStartTag() throws JspException {
        this._index = 0;
        this._count = 0;
        this.prepare();
        if (this.itemId != null) {
            this._initialVar = this.pageContext.getAttribute(this.itemId);
        }
        if (this.getLoopStatus() == null) {
            this._status = new Status();
        }
        while (this._index < this.begin && this.hasNext()) {
            ++this._index;
            this.next();
        }
        if (this.hasNext() && (this.end == -1 || this._index <= this.end)) {
            ++this._count;
            this._current = this.next();
            if (this.itemId != null) {
                if (this.deferredExpression != null) {
                    VariableMapper mapper = this.pageContext.getELContext().getVariableMapper();
                    this._mapped = mapper.setVariable(this.itemId, this.createIndexedExpression(this._index));
                } else {
                    this.pageContext.setAttribute(this.itemId, this._current);
                }
            }
            if (this.statusId != null) {
                this._oldStatus = this.pageContext.getAttribute(this.statusId, 1);
                if (!(this._oldStatus instanceof LoopTagStatus)) {
                    this._oldStatus = null;
                }
                this.pageContext.setAttribute(this.statusId, this.getLoopStatus());
            }
            return 1;
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        for (int stepCount = !this.stepSpecified ? 1 : this.step; stepCount > 0; --stepCount) {
            if (!this.hasNext()) {
                if (this.itemId != null) {
                    this.pageContext.setAttribute(this.itemId, this._initialVar);
                }
                return 0;
            }
            ++this._index;
            this._current = this.next();
        }
        ++this._count;
        if (this.end == -1 || this._index <= this.end) {
            if (this.itemId != null) {
                if (this.deferredExpression != null) {
                    VariableMapper mapper = this.pageContext.getELContext().getVariableMapper();
                    mapper.setVariable(this.itemId, this.createIndexedExpression(this._index));
                } else {
                    this.pageContext.setAttribute(this.itemId, this._current);
                }
            }
            return 2;
        }
        return 0;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        if (this.itemId != null) {
            if (this.deferredExpression != null) {
                VariableMapper mapper = this.pageContext.getELContext().getVariableMapper();
                mapper.setVariable(this.itemId, this._mapped);
            } else {
                this.pageContext.setAttribute(this.itemId, null);
            }
        }
        if (this.statusId != null) {
            this.pageContext.setAttribute(this.statusId, this._oldStatus);
        }
        this._mapped = null;
        this.deferredExpression = null;
    }

    protected String getDelims() {
        return ",";
    }

    private class Status
    implements LoopTagStatus {
        private Status() {
        }

        public Object getCurrent() {
            return LoopTagSupport.this._current;
        }

        public int getIndex() {
            return LoopTagSupport.this._index;
        }

        public int getCount() {
            return LoopTagSupport.this._count;
        }

        public boolean isFirst() {
            return LoopTagSupport.this._count == 1;
        }

        public boolean isLast() {
            try {
                if (!LoopTagSupport.this.hasNext()) {
                    return true;
                }
                return LoopTagSupport.this.endSpecified && LoopTagSupport.this.step + LoopTagSupport.this._index > LoopTagSupport.this.end;
            }
            catch (Exception e) {
                return false;
            }
        }

        public Integer getBegin() {
            if (LoopTagSupport.this.beginSpecified) {
                return new Integer(LoopTagSupport.this.begin);
            }
            return null;
        }

        public Integer getEnd() {
            if (LoopTagSupport.this.endSpecified) {
                return new Integer(LoopTagSupport.this.end);
            }
            return null;
        }

        public Integer getStep() {
            if (LoopTagSupport.this.stepSpecified) {
                return new Integer(LoopTagSupport.this.step);
            }
            return null;
        }
    }
}

