/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.ConfigException;
import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Defun;
import com.caucho.xtpdoc.LaTeXUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DefunJavadoc
implements ContentItem {
    private static final Logger log = Logger.getLogger(DefunJavadoc.class.getName());
    private final Defun _defun;
    private String _class;

    public DefunJavadoc(Defun defun) {
        this._defun = defun;
    }

    public void setClass(String cl) {
        this._class = cl;
    }

    private String getHref() {
        String path = this._class.replace('.', '/') + ".html";
        return "http://www.caucho.com/resin-javadoc/" + path;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("div");
        out.writeAttribute("class", "javadoc");
        out.writeStartElement("span");
        out.writeAttribute("class", "javadoc");
        out.writeCharacters("javadoc ");
        out.writeEndElement();
        out.writeStartElement("a");
        out.writeAttribute("href", this.getHref());
        out.writeCharacters(this._defun.getTitle());
        out.writeEndElement();
        out.writeEndElement();
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        out.print("{\\bf javadoc}");
        out.print("\\href{");
        out.print(this.getHref());
        out.print("}{");
        out.print(LaTeXUtil.escapeForLaTeX(this._defun.getTitle()));
        out.print("}\\\\");
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
    }

    public void writeLaTeXVerbatim(PrintWriter out) throws IOException {
        throw new ConfigException("<javadoc> not allowed in a verbatim context");
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
    }
}

