/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.Config;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xtpdoc.Anchor;
import com.caucho.xtpdoc.ChapterSection;
import com.caucho.xtpdoc.Document;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;

public class LinkedChapterSection
extends ChapterSection {
    private static final Logger log = Logger.getLogger(Anchor.class.getName());
    private String _link;

    public void setLink(String link) {
        this._link = link;
    }

    private Document configureDocument(Path xtpFile) {
        Document document = new Document(xtpFile, null);
        try {
            Config config = new Config();
            config.setEL(false);
            config.configure((Object)document, xtpFile);
            return document;
        }
        catch (Exception e) {
            System.err.println("Error configuring document (" + xtpFile + "): " + e);
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            } else {
                e.printStackTrace();
            }
            return null;
        }
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        Path xtpFile = Vfs.lookup((String)this._link);
        Document document = this.configureDocument(xtpFile);
        try {
            if (document != null) {
                document.writeLaTeX(out);
            }
        }
        catch (Exception e) {
            System.err.println("Error configuring document (" + xtpFile + "): " + e);
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            } else {
                e.printStackTrace();
            }
            return;
        }
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        Path xtpFile = Vfs.lookup((String)this._link);
        Document document = this.configureDocument(xtpFile);
        try {
            if (document != null) {
                document.writeLaTeXEnclosed(out);
            }
        }
        catch (Exception e) {
            System.err.println("Error configuring document (" + xtpFile + "): " + e);
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            } else {
                e.printStackTrace();
            }
            return;
        }
    }

    public void writeLaTeXArticle(PrintWriter out) throws IOException {
        Path xtpFile = Vfs.lookup((String)this._link);
        Document document = this.configureDocument(xtpFile);
        try {
            if (document != null) {
                document.writeLaTeXArticle(out);
            }
        }
        catch (Exception e) {
            System.err.println("Error configuring document (" + xtpFile + "): " + e);
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            } else {
                e.printStackTrace();
            }
            return;
        }
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        Path xtpFile = Vfs.lookup((String)this._link);
        Document document = this.configureDocument(xtpFile);
        try {
            if (document != null) {
                document.writeAsciiDoc(out);
            }
        }
        catch (Exception e) {
            System.err.println("Error configuring document (" + xtpFile + "): " + e);
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            } else {
                e.printStackTrace();
            }
            return;
        }
    }
}

