/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.ConfigException;
import com.caucho.xtpdoc.Body;
import com.caucho.xtpdoc.ContainerNode;
import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.Section;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Localtoc
implements ContentItem {
    Document _document;

    Localtoc(Document doc) {
        this._document = doc;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        Body container = this._document.getBody();
        this.writeContainer(out, container);
    }

    private void writeContainer(XMLStreamWriter out, ContainerNode container) throws XMLStreamException {
        if (container == null) {
            return;
        }
        out.writeCharacters("\n");
        out.writeStartElement("div");
        out.writeAttribute("class", "toc");
        this.writeContainerRec(out, container);
        out.writeEndElement();
    }

    private void writeContainerRec(XMLStreamWriter out, ContainerNode container) throws XMLStreamException {
        if (container == null) {
            return;
        }
        boolean wroteStart = false;
        for (ContentItem item : container.getItems()) {
            Section section;
            if (!(item instanceof Section) || (section = (Section)item).getTitle() == null || "".equals(section.getTitle())) continue;
            if (!wroteStart) {
                out.writeStartElement("ol");
                wroteStart = true;
            }
            out.writeStartElement("li");
            out.writeStartElement("a");
            out.writeAttribute("href", "#" + section.getHref());
            out.writeCharacters(section.getTitle());
            out.writeEndElement();
            this.writeContainerRec(out, section);
            out.writeEndElement();
        }
        if (wroteStart) {
            out.writeEndElement();
        }
    }

    public void writeLaTeX(PrintWriter writer) throws IOException {
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
    }

    public void writeLaTeXVerbatim(PrintWriter out) throws IOException {
        throw new ConfigException("<localtoc> not allowed in a verbatim context");
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
    }
}

