/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.Config;
import com.caucho.vfs.Path;
import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Description;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.Navigation;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationItem {
    private static final Logger log = Logger.getLogger(NavigationItem.class.getName());
    private Navigation _navigation;
    private NavigationItem _parent;
    private String _uri;
    private String _refUri;
    private int _maxDepth = 3;
    private int _depth;
    private boolean _isRelative;
    private String _link;
    private String _ref;
    private String _title;
    private String _product;
    private Document _document;
    private String _description;
    private ContentItem _fullDescription;
    private boolean _atocDescend;
    private Navigation _child;
    private ArrayList<NavigationItem> _items = new ArrayList();

    public NavigationItem(Navigation navigation, NavigationItem parent, int depth) {
        this._navigation = navigation;
        this._parent = parent;
        this._document = navigation.getDocument();
        this._depth = depth;
    }

    public Navigation getNavigation() {
        return this._navigation;
    }

    NavigationItem getParent() {
        return this._parent;
    }

    void setParent(NavigationItem parent) {
        this._parent = parent;
    }

    NavigationItem getPrevious() {
        NavigationItem parent = this.getParent();
        if (parent != null) {
            int p = parent._items.indexOf(this);
            if (p > 0) {
                NavigationItem ptr = this._parent._items.get(p - 1);
                while (ptr != null && ptr._items.size() > 0) {
                    ptr = ptr._items.get(ptr._items.size() - 1);
                }
                return ptr;
            }
            return parent;
        }
        return null;
    }

    NavigationItem getNext() {
        NavigationItem child = null;
        for (NavigationItem ptr = this; ptr != null; ptr = ptr.getParent()) {
            int p = ptr._items.indexOf(child);
            if (p < 0 && ptr._items.size() > 0) {
                return ptr._items.get(0);
            }
            if (p + 1 < ptr._items.size()) {
                return ptr._items.get(p + 1);
            }
            child = ptr;
        }
        return null;
    }

    ArrayList<NavigationItem> getChildren() {
        return this._items;
    }

    void addChildren(ArrayList<NavigationItem> children) {
        this._items.addAll(children);
    }

    String getUri() {
        return this._uri;
    }

    protected void initSummary() {
        Path linkPath;
        if (this._child != null || this._fullDescription != null) {
            return;
        }
        Path rootPath = this._document.getDocumentPath().getParent();
        if (this._uri != null && (linkPath = this._document.getRealPath(this._uri)).exists() && linkPath.getPath().endsWith(".xtp")) {
            Config config = new Config();
            config.setEL(false);
            try {
                config.configure((Object)this._document, linkPath);
                this._fullDescription = this._document.getHeader() != null ? this._document.getHeader().getDescription() : new Description(this._document);
            }
            catch (NullPointerException e) {
                log.info("error configuring " + linkPath + ": " + e);
            }
            catch (Exception e) {
                log.info("error configuring " + linkPath + ": " + e);
            }
            if (this._atocDescend) {
                Path linkRoot = linkPath.getParent();
                if (linkRoot.equals((Object)this._navigation.getRootPath().getParent())) {
                    return;
                }
                Path subToc = linkPath.getParent().lookup("toc.xml");
                if (subToc.exists()) {
                    this._child = new Navigation(this._navigation, this._uri, linkRoot, this._depth + 1);
                    try {
                        config.configure((Object)this._child, subToc);
                    }
                    catch (Exception e) {
                        log.info("Failed to configure " + subToc + ": " + e);
                    }
                } else {
                    log.info(subToc + " does not exist!");
                }
            }
        }
    }

    public void setATOCDescend(boolean atocDescend) {
        this._atocDescend = atocDescend;
    }

    public void setLink(String link) {
        this._link = link;
        this._isRelative = this._link.indexOf(58) < 0;
    }

    public String getLink() {
        return this._link;
    }

    public void setReference(String ref) {
        this._ref = ref;
    }

    public String getReference() {
        return this._ref;
    }

    public String getReferenceUri() {
        return this._refUri;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setProduct(String product) {
        this._product = product;
    }

    public NavigationItem createItem() {
        NavigationItem item = new NavigationItem(this._navigation, this, this._depth + 1);
        this._items.add(item);
        return item;
    }

    @PostConstruct
    public void init() {
        if (this._isRelative) {
            this._uri = this._navigation.getUri() + this._link;
            if (this._ref != null) {
                this._refUri = this._navigation.getUri() + this._ref;
            }
        } else {
            this._uri = this._link;
            if (this._ref != null) {
                this._refUri = this._ref;
            }
        }
        this._navigation.putItem(this._uri, this);
    }

    public void writeHtml(XMLStreamWriter out, String path) throws XMLStreamException {
        this.initSummary();
        out.writeStartElement("div");
        out.writeAttribute("class", "atoc-top");
        for (NavigationItem item : this._items) {
            item.writeHtmlImpl(out, path, 0, 0, 3);
        }
        out.writeEndElement();
    }

    public void writeHtml(XMLStreamWriter out, String path, int depth, int styleDepth, int maxDepth) throws XMLStreamException {
        if (depth + styleDepth <= 1) {
            this.initSummary();
        }
        for (NavigationItem item : this._items) {
            item.writeHtmlImpl(out, path, depth, styleDepth, maxDepth);
        }
    }

    protected void writeHtmlImpl(XMLStreamWriter out, String path, int depth, int styleDepth, int maxDepth) throws XMLStreamException {
        if (maxDepth <= depth) {
            return;
        }
        if (depth + styleDepth <= 1) {
            this.initSummary();
        }
        if (this._child != null && depth + 1 < maxDepth) {
            this._child.initSummary();
        }
        if (depth <= 1) {
            out.writeStartElement("h2");
            out.writeAttribute("class", "section");
            if (this._link != null) {
                out.writeStartElement("a");
                if (this._isRelative) {
                    out.writeAttribute("href", path + this._link);
                } else {
                    out.writeAttribute("href", this._link);
                }
                out.writeCharacters(this._title);
                out.writeEndElement();
            } else {
                out.writeCharacters(this._title);
            }
            out.writeEndElement();
        } else {
            out.writeStartElement("div");
            out.writeStartElement("b");
            if (this._link != null) {
                out.writeStartElement("a");
                if (this._isRelative) {
                    out.writeAttribute("href", path + this._link);
                } else {
                    out.writeAttribute("href", this._link);
                }
                out.writeCharacters(this._title);
                out.writeEndElement();
                if (this._ref != null) {
                    out.writeStartElement("span");
                    out.writeAttribute("class", "ref");
                    out.writeCharacters(" ");
                    out.writeEntityRef("laquo");
                    out.writeStartElement("a");
                    if (this._isRelative) {
                        out.writeAttribute("href", path + this._ref);
                    } else {
                        out.writeAttribute("href", this._ref);
                    }
                    out.writeCharacters("ref");
                    out.writeEndElement();
                    out.writeEntityRef("raquo");
                    out.writeEndElement();
                }
            }
            out.writeEndElement();
            if ((this._fullDescription == null || depth + styleDepth > 1) && this._description != null && depth > 1) {
                out.writeCharacters(" - ");
                out.writeCharacters(this._description);
            }
            out.writeEndElement();
        }
        out.writeStartElement("div");
        out.writeAttribute("class", "nav-item");
        if (this._fullDescription != null && depth + styleDepth <= 1) {
            this._fullDescription.writeHtml(out);
        }
        if (this._link != null) {
            int p = this._link.lastIndexOf(47);
            String tail = p >= 0 ? path + this._link.substring(0, p + 1) : path;
            String depthString = depth == 0 ? "top" : "" + depth;
            boolean hasDL = false;
            if (this._child != null || this._items.size() > 0) {
                out.writeStartElement("div");
                out.writeAttribute("class", "atoc-" + (depth + 1));
                if (this._child != null) {
                    this._child.writeHtml(out, tail, depth + 1, styleDepth, maxDepth);
                } else {
                    for (NavigationItem item : this._items) {
                        item.writeHtmlImpl(out, tail, depth + 1, styleDepth, maxDepth);
                    }
                }
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    public void writeLeftNav(XMLStreamWriter out) throws XMLStreamException {
        if (this._parent != null) {
            this._parent.writeLeftNavPre(out, this, 1);
        }
        this.writeLeftNavItem(out, this);
        if (this._items.size() > 0) {
            out.writeStartElement("div");
            out.writeAttribute("class", "leftnav");
            for (NavigationItem item : this._items) {
                item.writeLeftNavNoParent(out, this);
            }
            out.writeEndElement();
        }
        if (this._parent != null) {
            this._parent.writeLeftNavPost(out, this);
        }
    }

    public int writeLeftNavPre(XMLStreamWriter out, NavigationItem caller, int padding) throws XMLStreamException {
        if (this._parent != null) {
            padding = this._parent.writeLeftNavPre(out, this, padding);
        }
        this.writeLeftNavItem(out, caller);
        if (this._items.size() > 0) {
            out.writeStartElement("div");
            out.writeAttribute("class", "leftnav");
            for (NavigationItem item : this._items) {
                if (item.getUri().equals(caller.getUri())) {
                    return padding + 1;
                }
                item.writeLeftNavItem(out, caller);
            }
            return padding + 1;
        }
        return padding;
    }

    public void writeLeftNavPost(XMLStreamWriter out, NavigationItem caller) throws XMLStreamException {
        if (this._items.size() > 0) {
            boolean found = false;
            for (NavigationItem item : this._items) {
                if (found) {
                    item.writeLeftNavItem(out, caller);
                }
                if (!item.getUri().equals(caller.getUri())) continue;
                found = true;
            }
            out.writeEndElement();
        }
        if (this._parent != null) {
            this._parent.writeLeftNavPost(out, this);
        }
    }

    public void writeLeftNavNoParent(XMLStreamWriter out, NavigationItem caller) throws XMLStreamException {
        this.writeLeftNavItem(out, caller);
        if (this._items.size() > 0) {
            out.writeStartElement("div");
            out.writeAttribute("class", "leftnav");
            for (NavigationItem item : this._items) {
                item.writeLeftNavNoParent(out, this);
            }
            out.writeEndElement();
        }
    }

    private void writeLeftNavItem(XMLStreamWriter out, NavigationItem caller) throws XMLStreamException {
        out.writeStartElement("div");
        if (caller != null && this._uri.equals(caller.getUri())) {
            out.writeAttribute("class", "selected");
        } else {
            out.writeAttribute("class", "not-selected");
        }
        out.writeStartElement("a");
        out.writeAttribute("href", this._uri);
        out.writeAttribute("class", "leftnav");
        out.writeCharacters(this._title.toLowerCase(Locale.ENGLISH));
        out.writeEndElement();
        if (this._refUri != null) {
            out.writeStartElement("span");
            out.writeAttribute("class", "ref");
            out.writeCharacters(" ");
            out.writeEntityRef("laquo");
            out.writeStartElement("a");
            out.writeAttribute("href", this._refUri);
            out.writeAttribute("class", "leftnav");
            out.writeCharacters("ref");
            out.writeEndElement();
            out.writeEntityRef("raquo");
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    public void writeLink(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("a");
        out.writeAttribute("href", this._uri);
        out.writeCharacters(this._title.toLowerCase(Locale.ENGLISH));
        out.writeEndElement();
    }

    public void writeLaTeX(PrintWriter writer) throws IOException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getTitle() + "]";
    }
}

