/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.Config;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xtpdoc.Book;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Printer {
    private String _fileName;
    private boolean _isNew;

    public static void main(String[] args) {
        new Printer(args);
    }

    Printer(String[] args) {
        Config config = new Config();
        config.setEL(false);
        if (args.length == 0) {
            System.out.println("usage: " + Printer.class.getName() + " <book.xml>");
            System.exit(1);
        }
        this.parseArgs(args);
        Path xtpFile = Vfs.lookup((String)this._fileName);
        Book book = new Book();
        try {
            config.configure((Object)book, xtpFile);
            OutputStreamWriter osw = new OutputStreamWriter(System.out);
            PrintWriter out = new PrintWriter(osw);
            if (this._isNew) {
                book.writeAsciiDoc(out);
            } else {
                book.writeLaTeX(out);
            }
            osw.close();
            out.close();
        }
        catch (IOException e) {
            System.err.println("Error writing HTML: " + e);
        }
        catch (Exception e) {
            System.err.println("Error configuring document: " + e);
            e.printStackTrace();
        }
    }

    private void parseArgs(String[] args) {
        this._fileName = args[args.length - 1];
        if (args[0].equals("--new")) {
            this._isNew = true;
        }
    }
}

