/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.Config;
import com.caucho.vfs.Path;
import com.caucho.xtpdoc.Defun;
import com.caucho.xtpdoc.ReferenceDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class ReferenceServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(ReferenceServlet.class.getName());
    private XMLOutputFactory _outputFactory;
    private String _encoding = "utf-8";
    private ReferenceDocument _referenceDocument;
    private Path _referencePath;

    public void setReferenceDocument(Path referencePath) {
        this._referencePath = referencePath;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this._outputFactory = XMLOutputFactory.newInstance();
        }
        catch (FactoryConfigurationError e) {
            throw new ServletException("Error configuring factory", (Throwable)e);
        }
        if (this._outputFactory == null) {
            throw new ServletException("Error configuring factory");
        }
        String contextPath = servletConfig.getServletContext().getServletContextName();
        this._referenceDocument = new ReferenceDocument(this._referencePath, contextPath);
        this._referenceDocument.setJavascriptEnabled(false);
        Config config = new Config();
        config.setEL(false);
        try {
            config.configure((Object)this._referenceDocument, this._referencePath);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream os = response.getOutputStream();
        try {
            String ref = request.getParameter("ref");
            Defun defun = this._referenceDocument.getDefun(ref);
            if (defun == null) {
                response.sendError(404);
                return;
            }
            response.setContentType("text/html");
            XMLStreamWriter xmlOut = this._outputFactory.createXMLStreamWriter((OutputStream)os, this._encoding);
            defun.writeHtml(xmlOut);
            xmlOut.flush();
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            log.warning(e.toString());
            response.sendError(404);
        }
        catch (Exception e) {
            throw new ServletException("Error configuring document", (Throwable)e);
        }
    }
}

