/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.FormattedTextWithAnchors;
import com.caucho.xtpdoc.LaTeXUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Results
extends FormattedTextWithAnchors {
    private String _title;
    private String _language = null;

    public Results(Document document) {
        super(document);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        if (this._title != null) {
            out.writeStartElement("div");
            out.writeAttribute("class", "caption");
            out.writeCharacters(this._title);
            out.writeEndElement();
        }
        out.writeStartElement("div");
        out.writeAttribute("class", "results");
        super.writeHtml(out);
        out.writeEndElement();
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        out.println("\\begin{center}");
        out.println("\\begin{Verbatim}[frame=single,fontfamily=courier,");
        out.println("                  fillcolor=\\color{results-gray},");
        out.println("                  fontsize=\\footnotesize,");
        out.println("                  samepage=true]");
        super.writeLaTeX(out);
        out.println();
        out.println("\\end{Verbatim}");
        if (this._title != null) {
            out.println(LaTeXUtil.escapeForLaTeX(this._title));
        }
        out.println("\\end{center}");
    }
}

